////////////////////////////////////////////////////////
// filename: ChaDataObject.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2020/03/05
////////////////////////////////////////////////////////

#ifndef __CHADATAOBJECT_H__
#define __CHADATAOBJECT_H__

struct CMaterial{

	float4 diffuse;
	float4 ambient;
	float4 emmition;
	float4 specular;
	char MaterialName[SIZE_CHAR_MAX];
	char TextureName[SIZE_CHAR_MAX];
};

struct CVertex{

	float3 Pos;
	float3 Normal;
	float4 Color;
	float2 UV;
};

struct CTextureName{

	char TextureID[SIZE_CHAR_MAX];
	char TextureName[SIZE_CHAR_MAX];
};

class CVertexData{
public:
	char ID[SIZE_CHAR_MAX];
	CVector	*Data;

public:
	CVertexData();
	~CVertexData();
};

class CPolygonData{
public:
	char MaterialID[SIZE_CHAR_MAX];
	char VertexID[SIZE_CHAR_MAX];
	char NormalID[SIZE_CHAR_MAX];
	char TexID[SIZE_CHAR_MAX];
	char ColorID[SIZE_CHAR_MAX];
	CVector	*VertexIndex;
	CVector *NormalIndex;
	CVector *TexIndex;
	CVector *ColorIndex;

public:
	CPolygonData();
	~CPolygonData();
};

class CGeometry{
public:

	int		VertexCount;
	CVector	*Vertics;
	CVector	*PolygonData;

public:
	CGeometry();
	~CGeometry();
	CVertexData *GetVertexData(char *id);
};

class CChaDataObject{
public:

	CVector *Geometry;
	CVector	*Material;
	CVector	*TextureName;

public:

	CChaDataObject();
	~CChaDataObject();
	bool LoadDAE(wchar_t *filename);
	CMaterial *GetMaterial(char *id);
	int GetMaterialNum(char *id);
	CTextureName *GetTextureName(char *id);
	int GetTextureNum( int material_num );

private:
	bool LoadMaterial(MSXML2::IXMLDOMDocumentPtr pDoc);
	bool LoadTextureName(MSXML2::IXMLDOMDocumentPtr pDoc);
	bool LoadMesh(MSXML2::IXMLDOMDocumentPtr pDoc);
};

#endif