////////////////////////////////////////////////////////
// filename: VideoPanel.cpp
// author: 
// version: 1.0.0
// date: 2025/11/04
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "CControlWindow.h"
#include "CustomButton.h"
#include "MainWindow.h"
#include "VideoPanel.h"
#include "VideoPopUpWnd.h"

CVideoPopUpWnd::CVideoPopUpWnd() {

	g_pRenderTarget = nullptr;
}

CVideoPopUpWnd::~CVideoPopUpWnd() {

	g_pRenderTarget->Release();
}

bool CVideoPopUpWnd::CreateWnd(HWND ParentWnd, int x, int y, int w, int h) {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CVideoPopUpWnd::WindowProc;
	wcx.lpszClassName = L"CLASS_VIDEOPOPUPWND";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = w;
	Height = h;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_VIDEOPOPUPWND", APP_TITLE, WS_POPUP, x, y, w, h, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);

	CreateRenderTarget(m_hWnd, &g_pRenderTarget);
	CreateDrawResource();

	::ShowWindow(m_hWnd, SW_HIDE);

	return true;
}

bool CVideoPopUpWnd::CreateDrawResource() {

	return true;
}

LRESULT CVideoPopUpWnd::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CVideoPopUpWnd* video_panel = (CVideoPopUpWnd*) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (video_panel != NULL)
		video_panel->VideoPopUpWndProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CVideoPopUpWnd::VideoPopUpWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	switch (message) {
	case WM_PAINT:
		OnPaint();
		ValidateRect(m_hWnd, NULL);
		break;
	case WM_KEYDOWN:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_KEYDOWN, wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_LBUTTONDOWN, wParam, lParam);
		break;
	case WM_LBUTTONUP:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_LBUTTONUP, wParam, lParam);
		break;
	case WM_MOUSEMOVE:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_MOUSEMOVE, wParam, lParam);
		break;
	}

	return 0;
}

void CVideoPopUpWnd::OnPaint() {

	D2D1Draw();
}

bool CVideoPopUpWnd::D2D1Draw() {

	g_pRenderTarget->BeginDraw();

	if (theApp->MainWindow->MediaType == MEDIA_TYPE_VIDEO) {

		g_pRenderTarget->Clear(D2D1::ColorF(0, 0, 0, 1.0f));

		if (theApp->MainWindow->FirstFrameBMP != nullptr) {
			ComPtr <ID2D1Bitmap> bmp;
			g_pRenderTarget->CreateBitmapFromWicBitmap( theApp->MainWindow->FirstFrameBMP, &bmp);

			D2D1_RECT_F dest_rect;
			CalcImageSize(bmp.Get(), &dest_rect);
			g_pRenderTarget->DrawBitmap(bmp.Get(), dest_rect, 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR );
		}
	}
	
	g_pRenderTarget->EndDraw();

	return true;
}

bool CVideoPopUpWnd::CalcImageSize(ID2D1Bitmap* bmp, D2D1_RECT_F* rect) {

	D2D1_SIZE_F size = bmp->GetSize();

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float dpi_scale = 96.0f / float(dpi);

	float w = size.width;
	float h = size.height;

	float img_x = 0;
	float img_y = 0;
	float img_w = 0;
	float img_h = 0;

	if (h / w > (float)Height / (float)Width) {
		img_h = (float)Height * dpi_scale;
		img_w = (float)Height * dpi_scale / ((float)h / (float)w);
		img_x = (Width * dpi_scale - img_w) / 2.0f;
		img_y = 0.0f;
	}
	else {
		img_h = (float)Width * dpi_scale / ((float)w / (float)h);
		img_w = (float)Width * dpi_scale;
		img_x = 0.0f;
		img_y = (Height * dpi_scale - img_h) / 2.0f;
	}

	rect->left = img_x;
	rect->top = img_y;
	rect->right = img_x + img_w;
	rect->bottom = img_y + img_h;

	return true;
}

bool CVideoPopUpWnd::CalcImageSize(D2D1_RECT_F src_rect, D2D1_RECT_F* dest_rect) {

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float dpi_scale = 96.0f / float(dpi);

	float bmpWidth = theApp->MainWindow->FirstFrameWidth;
	float bmpHeight = theApp->MainWindow->FirstFrameHeight;

	float src_x = src_rect.left;
	float src_y = src_rect.top;
	float src_width = src_rect.right - src_rect.left;
	float src_height = src_rect.bottom - src_rect.top;

	if (bmpHeight / bmpWidth > (float)Height / (float)Width) {

		float scale = ((float)Height * dpi_scale / bmpHeight);
		float offset_x = (Width * dpi_scale - bmpWidth * scale) / 2.0f;
		float offset_y = 0.0f;

		dest_rect->left = offset_x + src_x * scale;
		dest_rect->top = offset_y + src_y * scale;
		dest_rect->right = offset_x + (src_x + src_width) * scale;
		dest_rect->bottom = offset_y + (src_y + src_height) * scale;
	}
	else {

		float scale = ((float)Width * dpi_scale / bmpWidth);
		float offset_x = 0.0f;
		float offset_y = (Height * dpi_scale - bmpHeight * scale) / 2.0f;

		dest_rect->left = offset_x + src_x * scale;
		dest_rect->top = offset_y + src_y * scale;
		dest_rect->right = offset_x + (src_x + src_width) * scale;
		dest_rect->bottom = offset_y + (src_y + src_height) * scale;
	}

	return true;
}


