////////////////////////////////////////////////////////
// filename: CControlWindow.cpp
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "MainWindow.h"
#include "CControlWindow.h"
#include "CustomButton.h"
#include "VideoPanel.h"

CControlWindow::CControlWindow() {

	m_hWnd = NULL;

	PosX = 0;
	PosY = 0;
	Width = CONTROL_WINDOW_WIDTH;
	Height = CONTROL_WINDOW_HEIGHT;

	Img_ButtonClose = NULL;
	Img_ButtonCloseDown = NULL;
	Img_ButtonPlay = NULL;
	Img_ButtonPlayDown = NULL;
	Img_ButtonPause = NULL;
	Img_ButtonPauseDown = NULL;

	LButtonDown = false;
	PlayCapture = false;
	TempPausing = false;

	BKColorA = 200;
	BKColorR = 130;
	BKColorG = 130;
	BKColorB = 150;

	g_pRenderTarget = nullptr;
	g_pBrush1 = nullptr;
	g_pBrush2 = nullptr;
	g_pBrush3 = nullptr;
	g_pBrush4 = nullptr;
	g_pBrush5 = nullptr;
	g_pBrush6 = nullptr;
	g_pBrush7 = nullptr;
	g_pFormat1 = nullptr;
	g_pFormat2 = nullptr;
	pLinearBrush = nullptr;
	pGradientStops = nullptr;
}

CControlWindow::~CControlWindow() {

	g_pRenderTarget->Release();
	g_pBrush1->Release();
	g_pBrush2->Release();
	g_pBrush3->Release();
	g_pBrush4->Release();
	g_pBrush5->Release();
	g_pBrush6->Release();
	g_pBrush7->Release();
	g_pFormat1->Release();
	g_pFormat2->Release();
	pLinearBrush->Release();
	pGradientStops->Release();
}

LRESULT CControlWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CControlWindow* main_wnd = (CControlWindow*) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (main_wnd != NULL)
		return main_wnd->ControlWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CControlWindow::ControlWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	if (message == WM_NCLBUTTONDOWN) {
		return 1; //EBhẼTCYύX֎~
	}

	int width, height, x, y;

	switch (message) {
	case WM_PAINT:
		OnPaint();
		ValidateRect(m_hWnd, NULL);
		break;
	case WM_NCHITTEST:
		SetFocus(m_hWnd);
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEMOVE:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnMouseMove((UINT)wParam, CPoint(x, y));
		break;
	case WM_PAUSE:
		theApp->MainWindow->Pause();
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
		break;
	case WM_PLAY:
		theApp->MainWindow->Play();
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
		break;
	case WM_KEYDOWN:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_KEYDOWN, wParam, lParam);
		break;
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////////

bool CControlWindow::CreateWnd( HWND ParentWnd, int x, int y, int width, int height ) {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CControlWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_ControlWindow";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = width;
	Height = height;

	m_hWnd = CreateWindowEx(WS_EX_LAYERED, L"CLASS_ControlWindow", APP_TITLE, WS_POPUP, PosX, PosY, Width, Height, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);
	::SetLayeredWindowAttributes(m_hWnd, RGB( 0, 0, 0 ), 220, LWA_ALPHA);

	CreateRenderTarget(m_hWnd, &g_pRenderTarget);
	CreateDrawResource();

	int button_size = (int) ( Height / 2.0);

	x = CONTROL_WINDOW_WIDTH - button_size - 20;
	y = ( Height - button_size ) / 2;

	wchar_t AppDir[SIZE_CHAR_MAX];
	wmemset(AppDir, 0, SIZE_CHAR_MAX);
	::GetModuleFileNameW(NULL, AppDir, SIZE_CHAR_MAX);
	::PathRemoveFileSpecW(AppDir);

	wchar_t path[SIZE_CHAR_MAX];
	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_CLOSE);
	if (LoadImage(path, g_pRenderTarget, &Img_ButtonClose) == false) {

		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_CLOSE);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_CLOSEDOWN);
	if (LoadImage(path, g_pRenderTarget, &Img_ButtonCloseDown) == false) {

		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_CLOSEDOWN);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	BTClose = new CBaseButton();
	BTClose->ButtonID = BUTTON_TYPE_CLOSE;
	BTClose->CreateWnd(m_hWnd, x, y, button_size, button_size );
	BTClose->SetImage(Img_ButtonClose, Img_ButtonCloseDown, Img_ButtonClose, Img_ButtonCloseDown);
	::ShowWindow(BTClose->m_hWnd, SW_SHOW);

	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_PLAY);
	if (LoadImage(path, g_pRenderTarget, &Img_ButtonPlay) == false) {

		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_PLAY);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_PLAYDOWN);
	if (LoadImage(path, g_pRenderTarget, &Img_ButtonPlayDown) == false) {

		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_PLAYDOWN);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_PAUSE);
	if( LoadImage( path, g_pRenderTarget, &Img_ButtonPause) == false ){
		
		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_PAUSE);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_BUTTON_PAUSEDOWN);
	if (LoadImage(path, g_pRenderTarget, &Img_ButtonPauseDown) == false) {

		wchar_t error_msg[SIZE_CHAR_MAX];
		wmemset(error_msg, 0, SIZE_CHAR_MAX);
		wcscpy_s(error_msg, SIZE_CHAR_MAX, TEXT_ERROR);
		wcscat_s(error_msg, SIZE_CHAR_MAX, PATH_BUTTON_PAUSEDOWN);
		::MessageBox(nullptr, error_msg, L"Load Error", MB_OK | MB_ICONERROR);

		exit(1);
	}

	button_size = (int)(Height / 1.5);
	x = 20;
	y = (Height - button_size) / 2;

	BTPlay = new CBaseButton();
	BTPlay->ButtonID = BUTTON_TYPE_PLAY;
	BTPlay->CreateWnd(m_hWnd, x, y, button_size, button_size);
	BTPlay->SetImage(Img_ButtonPlay, Img_ButtonPlayDown, Img_ButtonPause, Img_ButtonPauseDown);

	if( theApp->MainWindow->MediaType == MEDIA_TYPE_VIDEO)
		::ShowWindow(BTPlay->m_hWnd, SW_SHOW);

	SeekPosX = BTPlay->PosX + BTPlay->Width + 40;
	SeekPosY = (int) ( Height / 1.7f );
	SeekWidth = Width - BTPlay->Width - BTClose->Width - 100;
	SeekHeight = 10;

	return true;
}

bool CControlWindow::CreateDrawResource() {

	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF(0, 0, 0, 0), &g_pBrush1 );
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF(( BKColorR + 30 ) / 255.0f, ( BKColorG + 30 ) / 255.0f, ( BKColorB + 30 ) / 255.0f, 1.0f), &g_pBrush2);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR + 20) / 255.0f, (BKColorG + 20) / 255.0f, (BKColorB + 20) / 255.0f, 1.0f), &g_pBrush3);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR - 100) / 255.0f, (BKColorG - 100) / 255.0f, (BKColorB - 100) / 255.0f, 1.0f), &g_pBrush4);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR + 40) / 255.0f, (BKColorG + 40) / 255.0f, (BKColorB + 40) / 255.0f, 1.0f ), &g_pBrush5);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR - 30) / 255.0f, (BKColorG - 30) / 255.0f, (BKColorB - 30) / 255.0f, 1.0f ), &g_pBrush6);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR + 100) / 255.0f, (BKColorG + 100) / 255.0f, (BKColorB + 100) / 255.0f, 1.0f), &g_pBrush7);

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float scale = 96.0f / float( dpi );

	g_pDWriteFactory->CreateTextFormat( FONTNAME, nullptr, DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL, DWRITE_FONT_STRETCH_NORMAL, (Height / 6.0f) * scale, L"ja-jp", &g_pFormat1 );
	g_pDWriteFactory->CreateTextFormat( FONTNAME, nullptr, DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL, DWRITE_FONT_STRETCH_NORMAL, (Height / 3.5f) * scale, L"ja-jp", &g_pFormat2);

	DWRITE_TRIMMING trimming = {};
	trimming.granularity = DWRITE_TRIMMING_GRANULARITY_CHARACTER;

	ComPtr <IDWriteInlineObject> ellipsis;
	HRESULT hr = g_pDWriteFactory->CreateEllipsisTrimmingSign(g_pFormat1, &ellipsis);

	g_pFormat1->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);
	g_pFormat2->SetWordWrapping(DWRITE_WORD_WRAPPING_NO_WRAP);

	g_pFormat1->SetTrimming(&trimming, ellipsis.Get());
	g_pFormat2->SetTrimming(&trimming, ellipsis.Get());

	D2D1_GRADIENT_STOP gradientStops[2];
	gradientStops[0].color = D2D1::ColorF((BKColorR - 30) / 255.0f, (BKColorG - 30) / 255.0f, (BKColorB - 30) / 255.0f, 1.0f);
	gradientStops[0].position = 0.0f;
	gradientStops[1].color = D2D1::ColorF((BKColorR - 120) / 255.0f, (BKColorG - 120) / 255.0f, (BKColorB - 120) / 255.0f, 1.0f);
	gradientStops[1].position = 1.0f;

	g_pRenderTarget->CreateGradientStopCollection( gradientStops, 2, D2D1_GAMMA_2_2, D2D1_EXTEND_MODE_CLAMP, &pGradientStops );
	g_pRenderTarget->CreateLinearGradientBrush( D2D1::LinearGradientBrushProperties( D2D1::Point2F(0, 0), D2D1::Point2F(0, Height)), pGradientStops, &pLinearBrush );

	return true;
}

void CControlWindow::OnPaint() {

	D2D1Draw();
}

bool CControlWindow::D2D1Draw() {

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(0, 0, 0, 0));

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float scale = 96.0f / float(dpi);

	D2D1_ROUNDED_RECT rect1 = D2D1::RoundedRect(D2D1::RectF(0, 0, Width * scale, Height * scale), 0, 0 );
	g_pRenderTarget->FillRoundedRectangle(&rect1, pLinearBrush);
	g_pRenderTarget->DrawRoundedRectangle(&rect1, g_pBrush2, 6 * scale);

	if (theApp->MainWindow->MediaType == MEDIA_TYPE_UNKNOWN) {

		if( BTClose != NULL)
			BTClose->D2D1Draw(g_pRenderTarget, BTClose->PosX * scale, BTClose->PosY * scale, BTClose->Width * scale, BTClose->Height * scale);

		g_pRenderTarget->DrawTextW(TEXT_COMMENT_ERROR, wcslen(TEXT_COMMENT_ERROR), g_pFormat2, D2D1::RectF(50.0f * scale, ( Height / 4.0f ) * scale, ( Width / 1.5f ) * scale, ( Height / 4.0f + Height) * scale), g_pBrush7);
	}
	else if (theApp->MainWindow->MediaType == MEDIA_TYPE_VIDEO) {

		if( BTClose != NULL)
			BTClose->D2D1Draw(g_pRenderTarget, BTClose->PosX * scale, BTClose->PosY * scale, BTClose->Width * scale, BTClose->Height * scale);
		if( BTPlay != NULL )
			BTPlay->D2D1Draw(g_pRenderTarget, BTPlay->PosX * scale, BTPlay->PosY * scale, BTPlay->Width * scale, BTPlay->Height * scale);

		/////////////////////////////////////////////////////////////////////////////////////////////////

		//V[No[

		D2D1_ROUNDED_RECT rect2 = D2D1::RoundedRect(D2D1::RectF(SeekPosX * scale, SeekPosY * scale, ( SeekPosX + SeekWidth ) * scale, ( SeekPosY + SeekHeight) * scale ), 3 * scale, 3 * scale);
		g_pRenderTarget->FillRoundedRectangle(&rect2, g_pBrush4);
		g_pRenderTarget->DrawRoundedRectangle(&rect2, g_pBrush3, 3);

		int pos = 0;
		if (theApp->MainWindow->Length > 0) {
			double rate = (double)theApp->MainWindow->NowPos / (double)theApp->MainWindow->Length;
			pos = (int)(rate * SeekWidth);
		}

		D2D1_ROUNDED_RECT rect3 = D2D1::RoundedRect(D2D1::RectF( ( SeekPosX + pos - 8 ) * scale, ( SeekPosY - 6 ) * scale, ( SeekPosX + pos - 8 + 20 ) * scale, ( SeekPosY - 6 + 20) * scale ), 6 * scale, 6 * scale);
		g_pRenderTarget->FillRoundedRectangle(&rect3, g_pBrush6);
		g_pRenderTarget->DrawRoundedRectangle(&rect3, g_pBrush5, 3);

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
		g_pRenderTarget->DrawTextW(theApp->MainWindow->FileName, (UINT32) wcslen(theApp->MainWindow->FileName), g_pFormat1, D2D1::RectF(SeekPosX * scale, ( Height / 7.0f ) * scale, ( SeekPosX + SeekWidth / 1.5f ) * scale, ( Height / 7.0f + Height ) * scale ), g_pBrush7);

		float total_time = theApp->MainWindow->Length / 10000000.0f;
		int total_hour = (int)(total_time / 3600);
		int total_min = (int)(total_time - total_hour * 3600) / 60;
		int total_sec = (int)(total_time - total_hour * 3600 - total_min * 60);

		float now_time = theApp->MainWindow->NowPos / 10000000.0f;
		int now_hour = (int)(now_time / 3600);
		int now_min = (int)(now_time - now_hour * 3600) / 60;
		int now_sec = (int)(now_time - now_hour * 3600 - now_min * 60);

		wchar_t data[SIZE_CHAR_MAX];
		wmemset(data, 0, SIZE_CHAR_MAX);
		swprintf_s(data, SIZE_CHAR_MAX, L"[%02d:%02d:%02d / %02d:%02d:%02d]", now_hour, now_min, now_sec, total_hour, total_min, total_sec);

		g_pRenderTarget->DrawTextW(data, wcslen(data), g_pFormat1, D2D1::RectF(( SeekPosX + SeekWidth / 1.5f ) * scale, ( Height / 7.0f ) * scale, ( SeekPosX + Width ) * scale, ( Height / 7.0f + Height) * scale ), g_pBrush7);
	}
	else if (theApp->MainWindow->MediaType == MEDIA_TYPE_IMAGE) {

		if( BTClose != NULL)
			BTClose->D2D1Draw(g_pRenderTarget, BTClose->PosX * scale, BTClose->PosY * scale, BTClose->Width * scale, BTClose->Height * scale);

		g_pRenderTarget->DrawTextW(theApp->MainWindow->BitmapNames[theApp->MainWindow->CurrentImageNum], wcslen(theApp->MainWindow->BitmapNames[theApp->MainWindow->CurrentImageNum]), g_pFormat2, D2D1::RectF(50.0f * scale, ( Height / 4.0f ) * scale, ( Width / 1.5f ) * scale,  ( Height / 4.0f + Height) * scale ), g_pBrush7);

		wchar_t data[SIZE_CHAR_MAX];
		wmemset(data, 0, SIZE_CHAR_MAX);
		swprintf_s(data, SIZE_CHAR_MAX, L"[%03d / %03d]", theApp->MainWindow->CurrentImageNum+1, theApp->MainWindow->TotalImageNum);

		g_pRenderTarget->DrawTextW(data, wcslen(data), g_pFormat2, D2D1::RectF(( Width / 1.5f ) * scale, ( Height / 4.0f ) * scale, Width * scale, ( Height / 4.0f + Height) * scale ), g_pBrush7);
	}
	else if (theApp->MainWindow->MediaType == MEDIA_TYPE_ANIMATED_GIF) {

		if( BTClose != NULL)
			BTClose->D2D1Draw(g_pRenderTarget, BTClose->PosX * scale, BTClose->PosY * scale, BTClose->Width * scale, BTClose->Height * scale);

		g_pRenderTarget->DrawTextW(theApp->MainWindow->FileName, wcslen(theApp->MainWindow->FileName), g_pFormat2, D2D1::RectF(50.0f * scale, ( Height / 4.0f ) * scale, ( Width / 1.2f ) * scale, ( Height / 4.0f + Height) * scale ), g_pBrush7);
	}

	g_pRenderTarget->EndDraw();


	return true;
}

void CControlWindow::OnLButtonDown(UINT nFlags, CPoint point) {


	SetCapture(m_hWnd);
	LButtonDown = true;

	if (theApp->MainWindow->Length > 0) {
		if (theApp->MainWindow->Playing == true && theApp->MainWindow->Pausing == false) {
			TempPausing = true;
			theApp->MainWindow->Pause();
		}

		bool action = GetPlayBarPos(point);
		if (action == true)
			PlayCapture = true;
	}

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CControlWindow::OnLButtonUp(UINT nFlags, CPoint point) {

	ReleaseCapture();
	LButtonDown = false;

	if (theApp->MainWindow->Length > 0) {
		if (TempPausing == true) {
			theApp->MainWindow->Play();
		}
		TempPausing = false;
		PlayCapture = false;
	}

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CControlWindow::OnMouseMove(UINT nFlags, CPoint point) {

	if (LButtonDown == true && PlayCapture == true && theApp->MainWindow->Length > 0 ) {

		CPoint pos = point;
		bool action = GetPlayBarPos(pos);
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
}

////////////////////////////////////////////////////////////////////////////

bool CControlWindow::GetPlayBarPos(CPoint point) {

	int r = 15;
	if (point.x < SeekPosX - r || point.x > SeekPosX + SeekWidth + r)
		return false;
	if (point.y < SeekPosY - r || point.y > SeekPosY + SeekHeight + r)
		return false;

	PlayCapture = true;
	double rate = ((double)point.x - (double)SeekPosX) / ((double)SeekWidth);
	LONGLONG pos = (LONGLONG)(rate * (double)theApp->MainWindow->Length);

	static LONGLONG lastSeekTime = 0;
	if (GetTickCount64() - lastSeekTime > 200) {

		theApp->MainWindow->Seek(pos);
		lastSeekTime = GetTickCount64();

		return true;
	}

	return false;
}
