////////////////////////////////////////////////////////
// filename: VideoPanel.cpp
// author: 
// version: 1.0.0
// date: 2025/11/04
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "CControlWindow.h"
#include "CustomButton.h"
#include "MainWindow.h"
#include "VideoPanel.h"

CVideoPanel::CVideoPanel() {

	BKColorA = 200;
	BKColorR = 150;
	BKColorG = 140;
	BKColorB = 150;

	g_pRenderTarget = nullptr;
	g_pBrush1 = nullptr;
	g_pBrush2 = nullptr;
	g_pBrush3 = nullptr;
	g_pBrush4 = nullptr;
	g_pBrush5 = nullptr;
	g_pBrush6 = nullptr;
	g_pBrush7 = nullptr;
	g_pFormat1 = nullptr;
	g_pFormat2 = nullptr;
}

CVideoPanel::~CVideoPanel() {

	g_pRenderTarget->Release();
	g_pBrush1->Release();
	g_pBrush2->Release();
	g_pBrush3->Release();
	g_pBrush4->Release();
	g_pBrush5->Release();
	g_pBrush6->Release();
	g_pBrush7->Release();
	g_pFormat1->Release();
	g_pFormat2->Release();
}

bool CVideoPanel::CreateWnd(HWND ParentWnd, int x, int y, int w, int h) {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CVideoPanel::WindowProc;
	wcx.lpszClassName = L"CLASS_VIDEOPANEL";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = w;
	Height = h;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_VIDEOPANEL", APP_TITLE, WS_CHILD, x, y, w, h, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);

	CreateRenderTarget(m_hWnd, &g_pRenderTarget);
	CreateDrawResource();

	::ShowWindow(m_hWnd, SW_SHOW);

	return true;
}

bool CVideoPanel::CreateDrawResource() {

	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR + 60) / 255.0f, (BKColorG + 60) / 255.0f, (BKColorB + 80) / 255.0f, 1.0f), &g_pBrush1);
	g_pRenderTarget->CreateSolidColorBrush(D2D1::ColorF((BKColorR + 100) / 255.0f, (BKColorG + 100) / 255.0f, (BKColorB + 100) / 255.0f, 1.0f), &g_pBrush2);

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float scale = 96.0f / float(dpi);

	g_pDWriteFactory->CreateTextFormat(FONTNAME, nullptr, DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL, DWRITE_FONT_STRETCH_NORMAL, (Height / 40.0f) * scale, L"ja-jp", &g_pFormat1);
	g_pDWriteFactory->CreateTextFormat(FONTNAME, nullptr, DWRITE_FONT_WEIGHT_NORMAL, DWRITE_FONT_STYLE_NORMAL, DWRITE_FONT_STRETCH_NORMAL, (Height / 30.0f) * scale, L"ja-jp", &g_pFormat2);

	return true;
}

LRESULT CVideoPanel::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CVideoPanel* video_panel = (CVideoPanel*) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (video_panel != NULL)
		video_panel->VideoPanelProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CVideoPanel::VideoPanelProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	switch (message) {
	case WM_PAINT:
		OnPaint();
		ValidateRect(m_hWnd, NULL);
		break;
	case WM_NCHITTEST:
		SetFocus(m_hWnd);
		break;
	case WM_KEYDOWN:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_KEYDOWN, wParam, lParam);
		break;
	case WM_KEYUP:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_KEYUP, wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_LBUTTONDOWN, wParam, lParam);
		break;
	case WM_LBUTTONUP:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_LBUTTONUP, wParam, lParam);
		break;
	case WM_APP_MEDIA_ENDED:
		::SendMessage(theApp->MainWindow->m_hWnd, WM_APP_MEDIA_ENDED, wParam, lParam);
		break;
	case WM_APP_VIDEO_READY:
		MFVideoReady = true;
		break;
	case WM_TIMER:
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
		break;
	}

	return 0;
}

void CVideoPanel::OnPaint() {

	D2D1Draw();
}

bool CVideoPanel::D2D1Draw() {

	g_pRenderTarget->BeginDraw();

	if (theApp->MainWindow->MediaType == MEDIA_TYPE_UNKNOWN) {

		g_pRenderTarget->Clear(D2D1::ColorF(0, 0, 0, 1.0f));

		UINT dpi = GetDpiForWindow(m_hWnd);
		g_pRenderTarget->SetDpi(dpi, dpi);
		float scale = 96.0f / float(dpi);

		float x = ( Width / 4.0f );
		float y = ( Height / 6.0f );
		float text_width = ( Width / 2.0f ) * scale;
		float text_height = ( Height / 30.0f ) * scale;

		g_pRenderTarget->DrawBitmap(theApp->MainWindow->AppIcon, D2D1::RectF(x, y - 20, x + 80, y + 60), 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);

		g_pRenderTarget->DrawTextW(TEXT_APP_TITLE, wcslen(TEXT_APP_TITLE), g_pFormat2, D2D1::RectF(x + 100, y, x + 100 + text_width, y + text_height), g_pBrush1);

		y += 80.0f * scale;
		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT1, wcslen(TEXT_COMMENT1), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += 10.0f * scale;
		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT2, wcslen(TEXT_COMMENT2), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT3, wcslen(TEXT_COMMENT3), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += 30.0f * scale;
		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT4, wcslen(TEXT_COMMENT4), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += 50.0f * scale;
		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT5, wcslen(TEXT_COMMENT5), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += 10.0f * scale;
		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT6, wcslen(TEXT_COMMENT6), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT7, wcslen(TEXT_COMMENT7), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT8, wcslen(TEXT_COMMENT8), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT9, wcslen(TEXT_COMMENT9), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT10, wcslen(TEXT_COMMENT10), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT11, wcslen(TEXT_COMMENT11), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);

		y += text_height;
		g_pRenderTarget->DrawTextW(TEXT_COMMENT12, wcslen(TEXT_COMMENT12), g_pFormat1, D2D1::RectF(x, y, x + text_width, y + text_height), g_pBrush2);
	}
	else if (theApp->MainWindow->MediaType == MEDIA_TYPE_IMAGE) {

		g_pRenderTarget->Clear(D2D1::ColorF(0, 0, 0, 1.0f));

		ComPtr<IWICBitmap> current_bmp = theApp->MainWindow->WICBitmaps[theApp->MainWindow->CurrentImageNum];

		if (current_bmp != nullptr) {
			ComPtr <ID2D1Bitmap> bmp;
			g_pRenderTarget->CreateBitmapFromWicBitmap(current_bmp.Get(), &bmp);

			D2D1_RECT_F rect;
			CalcImageSize( bmp.Get(), &rect);
			g_pRenderTarget->DrawBitmap( bmp.Get(), rect, 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
		}
	}
	else if (theApp->MainWindow->MediaType == MEDIA_TYPE_ANIMATED_GIF) {

		ComPtr<ID2D1Bitmap> current_bmp = theApp->MainWindow->D2D1Bitmaps[theApp->MainWindow->CurrentFrameCount];
		D2D1_RECT_F rect = theApp->MainWindow->bmpRects[theApp->MainWindow->CurrentFrameCount];

		D2D1_RECT_F rect2;
		CalcImageSize(rect, &rect2);
		g_pRenderTarget->DrawBitmap(current_bmp.Get(), rect2, 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
	}

	g_pRenderTarget->EndDraw();

	return true;
}

bool CVideoPanel::CalcImageSize(ID2D1Bitmap* bmp, D2D1_RECT_F* rect) {

	D2D1_SIZE_F size = bmp->GetSize();

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float dpi_scale = 96.0f / float(dpi);

	float w = size.width;
	float h = size.height;

	float img_x = 0;
	float img_y = 0;
	float img_w = 0;
	float img_h = 0;

	if (h / w > (float)Height / (float)Width) {
		img_h = (float)Height * dpi_scale;
		img_w = (float)Height * dpi_scale / ((float)h / (float)w);
		img_x = (Width * dpi_scale - img_w) / 2.0f;
		img_y = 0.0f;
	}
	else {
		img_h = (float)Width * dpi_scale / ((float)w / (float)h);
		img_w = (float)Width * dpi_scale;
		img_x = 0.0f;
		img_y = (Height * dpi_scale - img_h) / 2.0f;
	}

	rect->left = img_x;
	rect->top = img_y;
	rect->right = img_x + img_w;
	rect->bottom = img_y + img_h;

	return true;
}

bool CVideoPanel::CalcImageSize(D2D1_RECT_F src_rect, D2D1_RECT_F* dest_rect) {

	UINT dpi = GetDpiForWindow(m_hWnd);
	g_pRenderTarget->SetDpi(dpi, dpi);
	float dpi_scale = 96.0f / float(dpi);

	float bmpWidth = theApp->MainWindow->bmpWidth;
	float bmpHeight = theApp->MainWindow->bmpHeight;

	float src_x = src_rect.left;
	float src_y = src_rect.top;
	float src_width = src_rect.right - src_rect.left;
	float src_height = src_rect.bottom - src_rect.top;

	if (bmpHeight / bmpWidth > (float)Height / (float)Width) {

		float scale = ((float)Height * dpi_scale / bmpHeight);
		float offset_x = (Width * dpi_scale - bmpWidth * scale) / 2.0f;
		float offset_y = 0.0f;

		dest_rect->left = offset_x + src_x * scale;
		dest_rect->top = offset_y + src_y * scale;
		dest_rect->right = offset_x + (src_x + src_width) * scale;
		dest_rect->bottom = offset_y + (src_y + src_height) * scale;
	}
	else {

		float scale = ((float)Width * dpi_scale / bmpWidth);
		float offset_x = 0.0f;
		float offset_y = (Height * dpi_scale - bmpHeight * scale) / 2.0f;

		dest_rect->left = offset_x + src_x * scale;
		dest_rect->top = offset_y + src_y * scale;
		dest_rect->right = offset_x + (src_x + src_width) * scale;
		dest_rect->bottom = offset_y + (src_y + src_height) * scale;
	}

	return true;
}


