////////////////////////////////////////////////////////
// filename: CControlWindow.h
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#ifndef __CONTROLWINDOW_H__
#define __CONTROLWINDOW_H__

class CBaseButton;

class CControlWindow {
public:

	HWND				m_hWnd;

	ID2D1HwndRenderTarget* g_pRenderTarget;
	ID2D1SolidColorBrush* g_pBrush1, *g_pBrush2, *g_pBrush3, *g_pBrush4, *g_pBrush5, *g_pBrush6, *g_pBrush7;
	ID2D1LinearGradientBrush* pLinearBrush;
	ID2D1GradientStopCollection* pGradientStops;
	IDWriteTextFormat* g_pFormat1, *g_pFormat2;

	char*				AlphaBMP;
	HDC					MemDC;
	HBITMAP			MemBMP;

	int			Width, Height;
	int			PosX, PosY;
	bool			LButtonDown;
	bool			PlayCapture;
	bool			TempPausing;

	CBaseButton		*BTClose;
	CBaseButton		*BTPlay;
	CBaseButton		*BTStop;

	ID2D1Bitmap* Img_ButtonClose;
	ID2D1Bitmap* Img_ButtonCloseDown;
	ID2D1Bitmap* Img_ButtonPlay;
	ID2D1Bitmap* Img_ButtonPlayDown;
	ID2D1Bitmap* Img_ButtonPause;
	ID2D1Bitmap* Img_ButtonPauseDown;

	int		SeekPosX, SeekPosY, SeekWidth, SeekHeight;

	int		BKColorA, BKColorR, BKColorG, BKColorB;

public:
	CControlWindow();
	~CControlWindow();
	bool CreateWnd( HWND ParentWnd, int x, int y, int width, int height );
	bool CreateDrawResource();
	bool D2D1Draw();
	bool GetPlayBarPos(CPoint point);

private:
	void OnPaint();
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnLButtonUp(UINT nFlags, CPoint point);
	void OnMouseMove(UINT nFlags, CPoint point);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT ControlWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

extern ID2D1Factory* g_pD2D1Factory;
extern IDWriteFactory* g_pDWriteFactory;
extern IWICImagingFactory* pWICFactory;

#endif