////////////////////////////////////////////////////////
// filename: main.cpp
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "MainWindow.h"

class CMain* theApp;

ID2D1Factory* g_pD2D1Factory = nullptr;
IDWriteFactory* g_pDWriteFactory = nullptr;
IWICImagingFactory* pWICFactory = nullptr;
bool MFVideoReady = false;
bool MFSeekCancel = false;
bool SeekProcessing = false;

int APIENTRY wWinMain(HINSTANCE hInst, HINSTANCE PrevInst, LPTSTR lpCmdLine, int nCmdShow) {

	int argc = 0;
	LPWSTR* argv = CommandLineToArgvW( GetCommandLineW(), &argc);

	CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);

	MFStartup(MF_VERSION);

	setlocale(LC_ALL, ".UTF8");

	theApp = new CMain();
	theApp->MainWindow = new CMainWindow();

	int type = GetMediaType(argv[1]);

	InitD2D();

	theApp->MainWindow->CreateWnd();
	theApp->MainWindow->MediaType = type;

	theApp->MainWindow->OpenMedia();

	::ShowWindow(theApp->MainWindow->m_hWnd, SW_SHOW);

	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0)) {

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	CoUninitialize();

	MFShutdown();

	return 1;
}

int GetMediaType( wchar_t *filename) {

	wchar_t* path = theApp->MainWindow->Path;
	wchar_t* name = theApp->MainWindow->FileName;

	if ( filename == NULL )
		return MEDIA_TYPE_UNKNOWN;

	wchar_t path_tmp[SIZE_CHAR_MAX];
	wmemset(path_tmp, 0, SIZE_CHAR_MAX);
	wcscpy_s(path_tmp, SIZE_CHAR_MAX, filename);
	PathRemoveFileSpecW(path_tmp);

	wcscpy_s(name, SIZE_CHAR_MAX, filename + wcslen( path_tmp ) + 1);

	if (wcscmp( &filename[wcslen(filename) - 4], L".png") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".PNG") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".jpg") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".JPG") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".jpeg") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".JPEG") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".webp") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".WEBP") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);
		PathRemoveFileSpecW(path);

		return MEDIA_TYPE_IMAGE;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".gif") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_ANIMATED_GIF;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".GIF") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_ANIMATED_GIF;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".wmv") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".WMV") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".avi") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".AVI") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".mp4") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".MP4") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".mov") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".MOV") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".webm") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".WEBM") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".mpeg") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 5], L".MPEG") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
	}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".mpg") == 0) {
		wcscpy_s(path, SIZE_CHAR_MAX, filename);

		return MEDIA_TYPE_VIDEO;
		}
	else if (wcscmp(&filename[wcslen(filename) - 4], L".MPG") == 0) {
			wcscpy_s(path, SIZE_CHAR_MAX, filename);

			return MEDIA_TYPE_VIDEO;
	}

	return MEDIA_TYPE_UNKNOWN;
}

void InitD2D() {

	D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &g_pD2D1Factory);
	DWriteCreateFactory(DWRITE_FACTORY_TYPE_SHARED, __uuidof(IDWriteFactory), (IUnknown**)&g_pDWriteFactory);

	CoCreateInstance(CLSID_WICImagingFactory, nullptr, CLSCTX_INPROC_SERVER, IID_PPV_ARGS(&pWICFactory));
}

void CreateRenderTarget(HWND hwnd, ID2D1HwndRenderTarget** render_target) {

	RECT rc;
	GetClientRect(hwnd, &rc);
	D2D1_SIZE_U size = D2D1::SizeU(rc.right, rc.bottom);

	D2D1_RENDER_TARGET_PROPERTIES prop = D2D1::RenderTargetProperties(D2D1_RENDER_TARGET_TYPE_DEFAULT, D2D1::PixelFormat(DXGI_FORMAT_R8G8B8A8_UNORM,  D2D1_ALPHA_MODE_PREMULTIPLIED), 0, 0, D2D1_RENDER_TARGET_USAGE_NONE, D2D1_FEATURE_LEVEL_DEFAULT);

	g_pD2D1Factory->CreateHwndRenderTarget( prop, D2D1::HwndRenderTargetProperties(hwnd, size), render_target );
}

bool LoadImage(const wchar_t *filename, ID2D1HwndRenderTarget* render_target, ID2D1Bitmap** bitmap){

	IWICBitmapDecoder* pDecoder = nullptr;
	HRESULT hr = pWICFactory->CreateDecoderFromFilename(filename, nullptr, GENERIC_READ, WICDecodeMetadataCacheOnLoad, &pDecoder);
	if (FAILED(hr))
		return false;

	IWICBitmapFrameDecode* pFrame = nullptr;
	pDecoder->GetFrame(0, &pFrame);

	IWICFormatConverter* pConverter = nullptr;
	hr = pWICFactory->CreateFormatConverter(&pConverter);
	if (FAILED(hr))
		return false;

	pConverter->Initialize(pFrame, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone, nullptr, 0, WICBitmapPaletteTypeCustom);

	hr = render_target->CreateBitmapFromWicBitmap(pConverter, nullptr, bitmap);
	if (FAILED(hr))
		return false;

	pFrame->Release();
	pDecoder->Release();
	pConverter->Release();

	return true;
}

bool LoadImage(const wchar_t* filename, IWICBitmap** bitmap) {

	IWICBitmapDecoder* pDecoder = nullptr;
	HRESULT hr = pWICFactory->CreateDecoderFromFilename(filename, nullptr, GENERIC_READ, WICDecodeMetadataCacheOnLoad, &pDecoder);
	if (FAILED(hr))
		return false;

	IWICBitmapFrameDecode* pFrame = nullptr;
	pDecoder->GetFrame(0, &pFrame);

	IWICFormatConverter* pConverter = nullptr;
	hr = pWICFactory->CreateFormatConverter(&pConverter);
	if (FAILED(hr))
		return false;

	hr = pConverter->Initialize(pFrame, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone, nullptr, 0, WICBitmapPaletteTypeCustom);
	if (FAILED(hr))
		return false;

	IWICMetadataQueryReader* pReader = nullptr;
	hr = pFrame->GetMetadataQueryReader(&pReader);
	UINT orientation = 1;
	if (SUCCEEDED(hr)){

		PROPVARIANT value;
		PropVariantInit(&value);
		if (SUCCEEDED(pReader->GetMetadataByName(L"/app1/ifd/{ushort=274}", &value))){
			if (value.vt == VT_UI2) orientation = value.uiVal;
			PropVariantClear(&value);
		}
	}

	IWICBitmapFlipRotator *pRotator = nullptr;
	hr = pWICFactory->CreateBitmapFlipRotator(&pRotator);
	if (FAILED(hr)) 
		return false;

	WICBitmapTransformOptions transform = WICBitmapTransformRotate0;

	switch (orientation){
	case 2: 
		transform = WICBitmapTransformFlipHorizontal; 
		break;
	case 3: 
		transform = WICBitmapTransformRotate180; 
		break;
	case 4: 
		transform = WICBitmapTransformFlipVertical; 
		break;
	case 5: 
		transform = (WICBitmapTransformOptions)(WICBitmapTransformRotate90 | WICBitmapTransformFlipHorizontal); 
		break;
	case 6: 
		transform = WICBitmapTransformRotate90; 
		break;
	case 7: 
		transform = (WICBitmapTransformOptions)(WICBitmapTransformRotate270 | WICBitmapTransformFlipHorizontal); 
		break;
	case 8: 
		transform = WICBitmapTransformRotate270; 
		break;
	default: 
		transform = WICBitmapTransformRotate0; 
		break;
	}

	hr = pRotator->Initialize(pConverter, transform);
	if (FAILED(hr)) 
		return false;

	hr = pWICFactory->CreateBitmapFromSource(pRotator, WICBitmapCacheOnLoad, bitmap);
	if (FAILED(hr))
		return false;

	pFrame->Release();
	pDecoder->Release();
	pConverter->Release();
	pRotator->Release();
	pReader->Release();

	return true;
}

bool LoadAnimatedGif(const wchar_t* filename, ID2D1HwndRenderTarget* render_target, std::vector<ComPtr<ID2D1Bitmap>> *bitmaps, std::vector<int>*delays, std::vector<int> *disposal, std::vector<D2D1_RECT_F> *bmpRects, UINT *frame_count, float *bmpWidth, float *bmpHeight   ) {

	IWICBitmapDecoder* pDecoder = nullptr;
	HRESULT hr = pWICFactory->CreateDecoderFromFilename(filename, nullptr, GENERIC_READ, WICDecodeMetadataCacheOnLoad, &pDecoder);
	if (FAILED(hr))
		return false;

	pDecoder->GetFrameCount(frame_count);

	ComPtr<IWICMetadataQueryReader> QueryReader;
	pDecoder->GetMetadataQueryReader(&QueryReader);

	PROPVARIANT prop = {};
	if (SUCCEEDED(QueryReader->GetMetadataByName(L"/logscrdesc/Width", &prop))) {
		*bmpWidth = prop.uiVal;
		PropVariantClear(&prop);
	}
	if (SUCCEEDED(QueryReader->GetMetadataByName(L"/logscrdesc/Height", &prop))) {
		*bmpHeight = prop.uiVal;
		PropVariantClear(&prop);
	}

	for( UINT i=0; i<=*frame_count-1; i++){

		ComPtr<IWICBitmapFrameDecode> pFrame;
		pDecoder->GetFrame(i, &pFrame);

		ComPtr<IWICMetadataQueryReader> frameReader;
		pFrame->GetMetadataQueryReader(&frameReader);

		PROPVARIANT delayProp = {};
		if (SUCCEEDED(frameReader->GetMetadataByName(L"/grctlext/Delay", &delayProp))){
			if (delayProp.uintVal == 0)
				delays->push_back(100);
			else
				delays->push_back( delayProp.uiVal * 10 );
			PropVariantClear(&delayProp);
		}

		PROPVARIANT disposalProp = {};
		if (SUCCEEDED(frameReader->GetMetadataByName(L"/grctlext/Disposal", &disposalProp))) {
			disposal->push_back(disposalProp.uiVal );
			PropVariantClear(&disposalProp);
		}

		ComPtr<IWICMetadataQueryReader> QueryReader;
		pFrame->GetMetadataQueryReader(&QueryReader);

		PROPVARIANT v = {};
		UINT left = 0, top = 0, width = 0, height = 0;
		if (SUCCEEDED(QueryReader->GetMetadataByName(L"/imgdesc/Left", &v))) { left = v.uiVal; PropVariantClear(&v); }
		if (SUCCEEDED(QueryReader->GetMetadataByName(L"/imgdesc/Top", &v))) { top = v.uiVal; PropVariantClear(&v); }
		if (SUCCEEDED(QueryReader->GetMetadataByName(L"/imgdesc/Width", &v))) { width = v.uiVal; PropVariantClear(&v); }
		if (SUCCEEDED(QueryReader->GetMetadataByName(L"/imgdesc/Height", &v))) { height = v.uiVal; PropVariantClear(&v); }

		D2D1_RECT_F rect;
		rect.top = (float)top;
		rect.left = (float)left;
		rect.bottom = rect.top + (float)height;
		rect.right = rect.left + (float)width;

		bmpRects->push_back(rect);

		IWICFormatConverter* pConverter = nullptr;
		pWICFactory->CreateFormatConverter(&pConverter);
		pConverter->Initialize(pFrame.Get(), GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone, nullptr, 0, WICBitmapPaletteTypeCustom);

		ID2D1Bitmap* bmp = nullptr;
		render_target->CreateBitmapFromWicBitmap(pConverter, nullptr, &bmp);

		bitmaps->push_back(bmp);

		pConverter->Release();
	}

	pDecoder->Release();
	pWICFactory->Release();

	return true;
}
