////////////////////////////////////////////////////////
// filename: MainWindow.cpp
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "CControlWindow.h"
#include "CustomButton.h"
#include "MainWindow.h"
#include "VideoPanel.h"

////////////////////////////////////////////////////////////////////////////////////////////

CMainWindow::CMainWindow() {

	m_hWnd = NULL;
	ControlWnd = NULL;

	AppExit = false;
	m_hThread = NULL;
	TimerID = 0;

	DisplayWidth = ::GetSystemMetrics(SM_CXSCREEN);
	DisplayHeight = ::GetSystemMetrics(SM_CYSCREEN);

	LButtonDown = false;
	ControlShow = false;
	wmemset(Path, 0, SIZE_CHAR_MAX);
	wmemset(FileName, 0, SIZE_CHAR_MAX);

	pVideoRenderer = nullptr;
	pVideoDisplay = nullptr;
	m_session = nullptr;
	m_source = nullptr;
	m_topology = nullptr;
	pCallback = nullptr;
	pAudioVolume = nullptr;

	MediaType = MEDIA_TYPE_UNKNOWN;
	Playing = false;
	Pausing = false;
	SeekProcessing = false;

	g_pRenderTarget = nullptr;
	TotalImageNum = 0;
	CurrentImageNum = 0;

	pFrameCount = 0;
	CurrentFrameCount = 0;

	MFStartup(MF_VERSION);
}

CMainWindow::~CMainWindow() {

	Close();

	MFShutdown();
}

BOOL CMainWindow::OnNcActivate(BOOL bActive) {

	return FALSE;
}

void CMainWindow::OnClose() {

	AppExit = true;
	if (TimerID != 0)
		timeKillEvent(TimerID);

	Sleep(50);

	::DestroyWindow(m_hWnd);

	::PostQuitMessage(1);
}

void CMainWindow::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) {

	if (MediaType == MEDIA_TYPE_UNKNOWN) {
		if (nChar == 122 /* F11 */) {
			::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
		}
		if (nChar == 32 /* space */) {
			::SendMessage(m_hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
		}
	}
	else if (MediaType == MEDIA_TYPE_VIDEO) {
		if (nChar == 37 /*  */) {
			if (Length > 0 && NowPos > 10000000 && SeekProcessing == false ) {
				SeekProcessing = true;
				LONGLONG pClockTime = 0;
				MFTIME pSystemTime = 0;
				HRESULT hr = m_session->GetClock(&pClock);
				hr = pClock->GetCorrelatedTime(0, &pClockTime, &pSystemTime);
				if (SUCCEEDED(hr) && pClockTime > 0) {
					Seek(NowPos - 100000000);
				}
				SeekProcessing = false;
			}
		}
		if (nChar == 39 /*  */) {
			if (Length > 0 && NowPos < Length - 10000000 && SeekProcessing == false  ) {
				SeekProcessing = true;
				LONGLONG pClockTime = 0;
				MFTIME pSystemTime = 0;
				HRESULT hr = m_session->GetClock(&pClock);
				hr = pClock->GetCorrelatedTime(0, &pClockTime, &pSystemTime);
				if (SUCCEEDED(hr) && pClockTime > 0) {
					Seek(NowPos + 100000000);
				}
				SeekProcessing = false;
			}
		}
		if (nChar == 122 /* F11 */) {
			::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
		}
		if (nChar == 32 /* space */) {
			::SendMessage(m_hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
		}
		if (nChar == 80 /* p */) {
			if (Playing == true && Pausing == false)
				Pause();
			else if (Pausing == true)
				Resume();
		}
	}
	else if (MediaType == MEDIA_TYPE_IMAGE) {
		if (nChar == 37 /*  */) {
			CurrentImageNum--;
			if (CurrentImageNum < 0)
				CurrentImageNum = TotalImageNum - 1;
			::SendMessage(ControlWnd->m_hWnd, WM_PAINT, 0, 0);
			::SendMessage(VideoPanel->m_hWnd, WM_PAINT, 0, 0);
		}
		else if (nChar == 39 /*  */) {
			CurrentImageNum++;
			if (CurrentImageNum >= TotalImageNum)
				CurrentImageNum = 0;
			::SendMessage(ControlWnd->m_hWnd, WM_PAINT, 0, 0);
			::SendMessage(VideoPanel->m_hWnd, WM_PAINT, 0, 0);
		}
		if (nChar == 122 /* F11 */) {
			::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
		}
		if (nChar == 32 /* space */) {
			::SendMessage(m_hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
		}
	}
	else if (MediaType == MEDIA_TYPE_ANIMATED_GIF) {
		if (nChar == 122 /* F11 */) {
			::SendMessage(m_hWnd, WM_CLOSE, 0, 0);
		}
		if (nChar == 32 /* space */) {
			::SendMessage(m_hWnd, WM_SYSCOMMAND, SC_MINIMIZE, 0);
		}
	}
}

void CMainWindow::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) {
}

LRESULT CMainWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CMainWindow* main_wnd = (CMainWindow*) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (main_wnd != NULL)
		main_wnd->MainWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CMainWindow::MainWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	int x, y;
	switch (message) {
	case WM_PAINT:
		OnPaint();
		ValidateRect(m_hWnd, NULL);
		break;
	case WM_CLOSE:
		OnClose();
		break;
	case WM_KEYDOWN:
		OnKeyDown((UINT)wParam, (UINT)LOWORD(lParam), (UINT)HIWORD(lParam));
		break;
	case WM_KEYUP:
		OnKeyUp((UINT)wParam, (UINT)LOWORD(lParam), (UINT)HIWORD(lParam));
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_APP_MEDIA_ENDED:
		VideoProcessEnd();
		break;
	case WM_TIMER:
		SendMessage(ControlWnd->m_hWnd, WM_PAINT, 0, 0);
		break;
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////////

bool CMainWindow::CreateWnd() {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CMainWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_MAINWINDOW";
	RegisterClassEx(&wcx);

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_MAINWINDOW", APP_TITLE, WS_OVERLAPPED | WS_CLIPCHILDREN, 0, 0, DisplayWidth, DisplayHeight, GetDesktopWindow(), NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);

	LONG style = ::GetWindowLong(m_hWnd, GWL_STYLE);
	style &= ~WS_CAPTION;
	style &= ~WS_BORDER;
	::SetWindowLong(m_hWnd, GWL_STYLE, style);

	VideoPanel = new CVideoPanel();
	VideoPanel->CreateWnd(m_hWnd, 0, 0, DisplayWidth, DisplayHeight);

	CreateRenderTarget( m_hWnd, &g_pRenderTarget);

	wchar_t AppDir[SIZE_CHAR_MAX];
	wmemset(AppDir, 0, SIZE_CHAR_MAX);
	::GetModuleFileNameW(NULL, AppDir, SIZE_CHAR_MAX);
	::PathRemoveFileSpecW(AppDir);

	wchar_t path[SIZE_CHAR_MAX];
	wmemset(path, 0, SIZE_CHAR_MAX);
	wcscpy_s(path, SIZE_CHAR_MAX, AppDir);
	wcscat_s(path, SIZE_CHAR_MAX, L"\\");
	wcscat_s(path, SIZE_CHAR_MAX, PATH_APPICON);
	LoadImage(path, VideoPanel->g_pRenderTarget, &AppIcon);

	int x = ( DisplayWidth - CONTROL_WINDOW_WIDTH ) / 2;
	int y = DisplayHeight - CONTROL_WINDOW_HEIGHT - 100;

	ControlWnd = new CControlWindow();
	ControlWnd->CreateWnd(m_hWnd, x, y, CONTROL_WINDOW_WIDTH, CONTROL_WINDOW_HEIGHT);

	::SetWindowPos(ControlWnd->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_HIDEWINDOW);
	::InvalidateRect(ControlWnd->m_hWnd, NULL, false);
	::UpdateWindow(ControlWnd->m_hWnd);
	
	return true;
}

void CMainWindow::OnPaint() {

	D2D1Draw();
}

bool CMainWindow::D2D1Draw() {

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(0, 0, 0, 1.0f));

	g_pRenderTarget->EndDraw();

	return true;
}

void CMainWindow::OnLButtonDown(UINT nFlags, CPoint point) {

	::ClientToScreen(m_hWnd, &point);
	LButtonDown = true;
	::SetCapture(m_hWnd);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CMainWindow::OnLButtonUp(UINT nFlags, CPoint point) {

	ReleaseCapture();

	LButtonDown = false;
	SetFocus(m_hWnd);

	if (ControlShow == false) {
		ControlShow = true;
		::SetWindowPos(ControlWnd->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
		::InvalidateRect(ControlWnd->m_hWnd, NULL, false);
		::UpdateWindow(ControlWnd->m_hWnd);
		SetCursor( true );
	}
	else {
		ControlShow = false;
		::SetWindowPos(ControlWnd->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_HIDEWINDOW);
		::SetFocus(m_hWnd);
		SetCursor( false );
	}

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

bool CMainWindow::SetCursor(bool show) {

	int c;
	if (show == true) {
		do {
			c = ShowCursor(TRUE);
		} while (c < 0);
	}
	else {
		do {
			c = ShowCursor(FALSE);
		} while (c >= 0);
	}

	return true;
}

void CMainWindow::OnMouseMove(UINT nFlags, CPoint point) {
}

///////////////////////////////////////////////////////////////////////

bool CMainWindow::OpenMedia() {

	if (MediaType == MEDIA_TYPE_VIDEO) {
		if (Open() == true) {
			Play();
			SetCursor(false);
			SetFocus(m_hWnd);
			TimerID = ::timeSetEvent(VIDEO_CHECK_INTERVAL_MILLISEC, 1, (LPTIMECALLBACK)VideoProcessCheckCallBack, NULL, TIME_PERIODIC);
			::SetTimer(m_hWnd, 1, UI_UPDATE_INTERVAL_MILLISEC, NULL);

			return true;
		}
		else 
			MediaType = MEDIA_TYPE_UNKNOWN;
	}
	else if (MediaType == MEDIA_TYPE_IMAGE) {

		if (LoadDirectoryImages() == true) {

			BeginImgLoadThread();

			::SetTimer(VideoPanel->m_hWnd, 1, 100, NULL);

			SetCursor(false);
			SetFocus(m_hWnd);

			::InvalidateRect(m_hWnd, NULL, false);
			::UpdateWindow(m_hWnd);

			return true;
		}
		else
			MediaType = MEDIA_TYPE_UNKNOWN;
	}
	else if (MediaType == MEDIA_TYPE_ANIMATED_GIF) {

		if (LoadAnimatedGif(Path, VideoPanel->g_pRenderTarget, &D2D1Bitmaps, &Delays, &Disposal, &bmpRects, &pFrameCount, &bmpWidth, &bmpHeight) == true) {
			SetCursor(false);
			SetFocus(m_hWnd);

			::InvalidateRect(m_hWnd, NULL, false);
			::UpdateWindow(m_hWnd);

			GifAnimationStart();

			return true;
		}
		else
			MediaType = MEDIA_TYPE_UNKNOWN;
	}

	return false;
}

bool CMainWindow::BeginImgLoadThread() {

	if (AppExit == true)
		return false;

	if (m_pThread == NULL) {
		UINT id = 100;
		m_hThread = (HANDLE) _beginthreadex(NULL, 0, &LoadImages, (void*)this, 0, &id);
	}

	return true;
}

unsigned _stdcall CMainWindow::LoadImages(void* Param) {

	CMainWindow *main_wnd = (CMainWindow *)Param;

	if (main_wnd->TotalImageNum > 0) {
		while (main_wnd->AppExit == false) {

			int current_num = main_wnd->CurrentImageNum;

			for (int i = 0; i <= 10; i++) {

				int num = (current_num + i) % main_wnd->TotalImageNum;

				if (main_wnd->WICBitmaps[num] == nullptr ) {
					ComPtr<IWICBitmap> NewBmp;
					if( LoadImage(main_wnd->BitmapPath[num], &NewBmp) == true)
						main_wnd->WICBitmaps[num] = NewBmp;
				}
			}
			for (int i = 0; i <= 10; i++) {

				int num = (current_num - i + main_wnd->TotalImageNum * 10) % main_wnd->TotalImageNum;

				if (main_wnd->WICBitmaps[num] == nullptr ) {
					ComPtr<IWICBitmap> NewBmp;
					if( LoadImage(main_wnd->BitmapPath[num], &NewBmp) == true)
						main_wnd->WICBitmaps[num] = NewBmp;
				}
			}

			Sleep(300);
		}
	}

	CloseHandle(main_wnd->m_hThread);
	main_wnd->m_hThread = NULL;

	return true;
}

bool CMainWindow::GifAnimationStart() {

	if (AppExit == true)
		return false;

	UINT id = 101;
	TimerID = ::timeSetEvent( 30, 1, (LPTIMECALLBACK)GifAnimationCallBack, NULL, TIME_ONESHOT);

	return true;
}

void CALLBACK CMainWindow::GifAnimationCallBack(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2) {

	::InvalidateRect(theApp->MainWindow->VideoPanel->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->VideoPanel->m_hWnd);

	theApp->MainWindow->CurrentFrameCount++;
	if (theApp->MainWindow->CurrentFrameCount >= theApp->MainWindow->pFrameCount)
		theApp->MainWindow->CurrentFrameCount = 0;

	UINT delay_time = theApp->MainWindow->Delays[theApp->MainWindow->CurrentFrameCount];
	if (delay_time <= 0)
		delay_time = 10;

	theApp->MainWindow->TimerID = ::timeSetEvent(delay_time, 1, (LPTIMECALLBACK)GifAnimationCallBack, NULL, TIME_ONESHOT);
}

///////////////////////////////////////////////////////////////////////

bool CMainWindow::LoadDirectoryImages() {

	WIN32_FIND_DATA	fData;
	wmemset(fData.cFileName, 0, 128);

	wchar_t filename[SIZE_CHAR_MAX];
	wchar_t extention[SIZE_CHAR_MAX];
	wchar_t filepath[SIZE_CHAR_MAX];
	wmemset(filepath, 0, SIZE_CHAR_MAX);
	wcscpy_s(filepath, SIZE_CHAR_MAX, Path);
	wcscat_s(filepath, L"/*");

	bool img_open = false;

	HANDLE hFile = ::FindFirstFile(filepath, &fData);
	if (hFile != NULL) {
		do {
			wmemset(filename, 0, SIZE_CHAR_MAX);

			if ((fData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) && !(fData.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN))
				continue;
			else if (wcscmp(filename, L".") != 0 && wcscmp(filename, L"..") != 0) {

				wcscpy_s(filename, SIZE_CHAR_MAX, fData.cFileName);
				GetExtention(filename, extention);

				if (extention != NULL) {
					if ((wcscmp(extention, L".jpg") == 0 || wcscmp(extention, L".JPG") == 0) || wcscmp(extention, L".jpeg") == 0 || wcscmp(extention, L".JPEG") == 0 || wcscmp(extention, L".webp") == 0 || wcscmp(extention, L".WEBP") == 0 || wcscmp(extention, L".png") == 0 || wcscmp(extention, L".PNG") == 0) {

						if (wcscmp(filename, FileName) == 0) {
							CurrentImageNum = TotalImageNum;
							img_open = true;
						}
						TotalImageNum++;

						wchar_t* path = new wchar_t[SIZE_CHAR_MAX];
						wmemset(path, 0, SIZE_CHAR_MAX);
						wcscpy_s(path, SIZE_CHAR_MAX, Path);
						wcscat_s(path, SIZE_CHAR_MAX, L"\\");
						wcscat_s(path, SIZE_CHAR_MAX, filename);

						BitmapPath.push_back(path);
						WICBitmaps.push_back(nullptr);

						wchar_t* name = new wchar_t[SIZE_CHAR_MAX];
						wmemset(name, 0, SIZE_CHAR_MAX);
						wcscpy_s(name, SIZE_CHAR_MAX, filename);
						BitmapNames.push_back(name);
					}
				}
			}
		} while (::FindNextFile(hFile, &fData));

		FindClose(hFile);
	}

	return img_open;
}

bool CMainWindow::GetExtention(wchar_t* filename, wchar_t *extention ) {

	wmemset(extention, 0, SIZE_CHAR_MAX);

	int i = wcslen(filename);
	for( ; i>=0; i--){
		wchar_t c[16];
		wmemset(c, 0, 16);
		wmemcpy_s(c, 1, &filename[i], 1);
		if (wcscmp(c, L".") == 0) {
			wmemcpy_s(extention, wcslen(filename) - i, &filename[i], wcslen(filename) - i);

			return true;
		}
	}

	return false;
}

///////////////////////////////////////////////////////////////////////

bool CMainWindow::Open() {

	HRESULT hr = MFCreateMediaSession(nullptr, &m_session);

	hr = CreateMediaSourceFromFile(Path, &m_source);
	if (FAILED(hr))
		return false;

	SetMediaSource(m_source);

	MSG msg;
	while (MFVideoReady == false) {
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	if (pVideoDisplay == NULL) {

		MFVideoReady = false;

		return false;
	}

	IMFPresentationDescriptor* pPD = nullptr;
	hr = m_source->CreatePresentationDescriptor(&pPD);
	if (SUCCEEDED(hr)) {
		UINT64 duration = 0;
		hr = pPD->GetUINT64(MF_PD_DURATION, &duration);
		if (SUCCEEDED(hr)) {
			Length = duration;
		}
		pPD->Release();
	}

	NowPos = 0;
	Playing = false;
	Pausing = false;

	return true;
}

bool CMainWindow::Play() {

	if (MFVideoReady == false)
		return false;

	if (Playing == false) {

		Playing = true;
		Pausing = false;

		PROPVARIANT var;
		PropVariantInit(&var);
		var.vt = VT_EMPTY;
		m_session->Start(&GUID_NULL, &var);

		ControlWnd->BTPlay->InAction = true;
		ControlWnd->BTPlay->LButtonDown = false;
		::InvalidateRect(ControlWnd->m_hWnd, NULL, false);
		::UpdateWindow(ControlWnd->m_hWnd);

		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
	else {
		if (Pausing == true) {
			Resume();
		}
	}

	return true;
}

bool CMainWindow::Stop() {

	if (MFVideoReady == false)
		return false;

	if (Playing == false && Pausing == false)
		return false;

	Playing = false;
	Pausing = false;

	NowPos = 0;
	Seek(NowPos);

	m_session->Stop();

	ControlWnd->BTPlay->InAction = false;
	ControlWnd->BTPlay->LButtonDown = false;

	return true;
}

bool CMainWindow::Pause() {

	if (MFVideoReady == false)
		return false;

	if (Pausing == true)
		return false;

	Playing = false;
	Pausing = true;

	m_session->Pause();

	ControlWnd->BTPlay->InAction = false;
	ControlWnd->BTPlay->LButtonDown = false;
	::InvalidateRect(ControlWnd->m_hWnd, NULL, false);
	::UpdateWindow(ControlWnd->m_hWnd);

	return true;
}

bool CMainWindow::Resume() {

	if (MFVideoReady == false)
		return false;

	Pausing = false;

	Play();

	return true;
}

bool CMainWindow::Seek(LONGLONG pos) {

	if (MFVideoReady == false)
		return false;

	if (pos < 0)
		pos = 0;
	if (pos > Length)
		pos = Length;

	NowPos = pos;

	LONGLONG seek_position = pos;
	PROPVARIANT var;
	PropVariantInit(&var);
	var.vt = VT_I8;
	var.hVal.QuadPart = seek_position;

	m_session->Start(nullptr, &var);
	PropVariantClear(&var);

	if (Pausing == true)
		m_session->Pause();

	return true;
}

bool CMainWindow::Close() {

	if (MFVideoReady == false)
		return false;

	if (m_session != NULL) {
		m_session->Stop();
		m_session->Close();
		m_session->Shutdown();
		m_session->Release();
		m_session = nullptr;
	}

	if (pAudioVolume != NULL) {
		pAudioVolume->Release();
		pAudioVolume = nullptr;
	}

	if (pCallback != NULL) {
		pCallback->Release();
		pCallback = nullptr;
	}

	if (m_source != NULL) {
		m_source->Shutdown();
		m_source->Release();
		m_source = nullptr;
	}

	if (m_topology != NULL) {
		m_topology->Release();
		m_topology = nullptr;
	}

	if (pVideoDisplay != NULL) {
		pVideoDisplay->Release();
		pVideoDisplay = nullptr;
	}

	if (MFVideoReady == false)
		return false;

	Playing = false;
	Pausing = false;
	MFVideoReady = false;

	return true;
}

LRESULT CMainWindow::VideoProcessEnd() {

	::timeKillEvent(TimerID);

	SeekProcessing = true;

	Seek(0);

	SeekProcessing = false;

	MFSeekCancel = false;
	TimerID = ::timeSetEvent(VIDEO_CHECK_INTERVAL_MILLISEC, 1, (LPTIMECALLBACK)VideoProcessCheckCallBack, NULL, TIME_PERIODIC);

	return S_OK;
}

void CALLBACK CMainWindow::VideoProcessCheckCallBack(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2) {

	LONGLONG pClockTime = 0;
	MFTIME pSystemTime = 0;
	if (theApp->MainWindow->Pausing == false && SeekProcessing == false ) {
		SeekProcessing = true;
		HRESULT hr = theApp->MainWindow->m_session->GetClock(&theApp->MainWindow->pClock);
		if (SUCCEEDED(hr)) {
			hr = theApp->MainWindow->pClock->GetCorrelatedTime(0, &pClockTime, &pSystemTime);
			if (pClockTime > 0 && theApp->MainWindow->Length > 0 ) {
				theApp->MainWindow->NowPos = pClockTime;
				if ( theApp->MainWindow->Length - pClockTime < VIDEO_END_MARGIN_MILLISEC * 100000 && MFSeekCancel == false ) {

					::SendMessage(theApp->MainWindow->VideoPanel->m_hWnd, WM_APP_MEDIA_ENDED, 0, 0);
					SeekProcessing = false;

					return;
				}
			}
		}
		SeekProcessing = false;
	}
}

HRESULT CMainWindow::CreateMediaSourceFromFile(LPCWSTR filename, IMFMediaSource** pSource) {

	if (pSource == NULL)
		return E_POINTER;

	*pSource = nullptr;

	IMFSourceResolver* pResolver = nullptr;
	IUnknown* pSourceUnk = nullptr;
	MF_OBJECT_TYPE ObjectType = MF_OBJECT_INVALID;

	HRESULT hr = MFCreateSourceResolver(&pResolver);
	if (FAILED(hr))
		return hr;

	hr = pResolver->CreateObjectFromURL(filename, MF_RESOLUTION_MEDIASOURCE, nullptr, &ObjectType, &pSourceUnk);
	if (SUCCEEDED(hr)) {

		hr = pSourceUnk->QueryInterface(IID_PPV_ARGS(pSource));
		pSourceUnk->Release();
	}

	pResolver->Release();

	return hr;
}

HRESULT CMainWindow::SetMediaSource(IMFMediaSource* pSource) {

	if (m_session == NULL)
		return E_FAIL;

	if (pSource == NULL)
		return E_POINTER;

	m_source = pSource;
	m_source->AddRef();

	IMFTopology* pTopology = nullptr;
	TOPOID videoSinkNodeID, audioSinkNodeID;

	CreateTopologyForSource(m_source, &pTopology, &videoSinkNodeID, &audioSinkNodeID);
	if (pTopology == NULL)
		return E_FAIL;

	m_topology = pTopology;

	pCallback = new CMediaSessionCallback(m_session, pTopology, videoSinkNodeID, audioSinkNodeID, VideoPanel->m_hWnd, &pVideoDisplay, &pAudioVolume );

	m_session->BeginGetEvent(pCallback, nullptr);

	m_session->SetTopology(0, m_topology);

	return S_OK;
}

HRESULT CMainWindow::CreateTopologyForSource(IMFMediaSource* pSource, IMFTopology** ppTopology, TOPOID* videoSinkNodeID, TOPOID* audioSinkNodeID) {

	IMFTopology* pTopology = nullptr;
	IMFPresentationDescriptor* pPD = nullptr;
	IMFStreamDescriptor* pSD = nullptr;
	IMFTopologyNode* pSourceNode = nullptr;
	IMFTopologyNode* pOutputNode = nullptr;
	IMFActivate* pVideoRendererActivate = nullptr;
	IMFActivate* pAudioRendererActivate = nullptr;

	HRESULT hr = MFCreateTopology(&pTopology);
	if (FAILED(hr))
		return E_FAIL;

	hr = pSource->CreatePresentationDescriptor(&pPD);
	if (FAILED(hr))
		return E_FAIL;

	DWORD cStreams = 0;
	hr = pPD->GetStreamDescriptorCount(&cStreams);
	if (FAILED(hr))
		return E_FAIL;

	for (DWORD i = 0; i < cStreams; i++) {

		BOOL fSelected = FALSE;
		hr = pPD->GetStreamDescriptorByIndex(i, &fSelected, &pSD);
		if (FAILED(hr))
			break;

		if (fSelected == NULL) 
			continue;

		IMFMediaTypeHandler* pHandler = nullptr;
		GUID majorType = GUID_NULL;
		hr = pSD->GetMediaTypeHandler(&pHandler);
		if (SUCCEEDED(hr)) {

			pHandler->GetMajorType(&majorType);
			pHandler->Release();
		}

		hr = MFCreateTopologyNode(MF_TOPOLOGY_SOURCESTREAM_NODE, &pSourceNode);
		if (FAILED(hr))
			break;

		hr = pSourceNode->SetUnknown(MF_TOPONODE_SOURCE, pSource);
		if (FAILED(hr))
			break;

		hr = pSourceNode->SetUnknown(MF_TOPONODE_PRESENTATION_DESCRIPTOR, pPD);
		if (FAILED(hr))
			break;

		hr = pSourceNode->SetUnknown(MF_TOPONODE_STREAM_DESCRIPTOR, pSD);
		if (FAILED(hr))
			break;

		hr = MFCreateTopologyNode(MF_TOPOLOGY_OUTPUT_NODE, &pOutputNode);
		if (FAILED(hr))
			break;

		if (majorType == MFMediaType_Video) {

			pOutputNode->GetTopoNodeID(videoSinkNodeID);

			hr = MFCreateVideoRendererActivate(VideoPanel->m_hWnd, &pVideoRendererActivate);
			if (FAILED(hr))
				break;

			pOutputNode->SetObject(pVideoRendererActivate);
			pOutputNode->SetUINT32(MF_TOPONODE_STREAMID, 0);
			pOutputNode->SetUINT32(MF_TOPONODE_NOSHUTDOWN_ON_REMOVE, false);
		}
		else if (majorType == MFMediaType_Audio) {

			pOutputNode->GetTopoNodeID(audioSinkNodeID);

			hr = MFCreateAudioRendererActivate(&pAudioRendererActivate);
			if (FAILED(hr))
				break;

			pOutputNode->SetObject(pAudioRendererActivate);
		}

		pTopology->AddNode(pOutputNode);
		pTopology->AddNode(pSourceNode);

		hr = pSourceNode->ConnectOutput(0, pOutputNode, 0);
		if (FAILED(hr))
			return E_FAIL;

		pOutputNode->Release();
		pOutputNode = nullptr;
		pSourceNode->Release();
		pSourceNode = nullptr;
		if (pVideoRendererActivate) {
			pVideoRendererActivate->Release(); 
			pVideoRendererActivate = nullptr; 
		}
		if (pAudioRendererActivate) { 
			pAudioRendererActivate->Release(); 
			pAudioRendererActivate = nullptr; 
		}
	}

	*ppTopology = pTopology;
	(*ppTopology)->AddRef();

	if (pPD) 
		pPD->Release();

	if (pSD) 
		pSD->Release();

	if (pTopology) 
		pTopology->Release();

	if (pSourceNode) 
		pSourceNode->Release();

	if (pOutputNode) 
		pOutputNode->Release();

	if (pVideoRendererActivate) 
		pVideoRendererActivate->Release();

	if (pAudioRendererActivate) 
		pAudioRendererActivate->Release();

	return hr;
}
