////////////////////////////////////////////////////////
// filename: CustomButton.cpp
// author: 
// version: 1.0.0
// date: 2025/10/31
////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "main.h"
#include "CustomButton.h"
#include "MainWindow.h"
#include "CControlWindow.h"
#include "VideoPanel.h"

CBaseButton::CBaseButton() {

	Width = 100;
	Height = 100;
	LButtonDown = false;
	InAction = false;
	ButtonType = BUTTON_TYPE_UNKNOWN;
	ButtonID = 0;

	Img_Normal = NULL;
	Img_NormalMouseDown = NULL;
	Img_InActionNormal = NULL;
	Img_InActionMouseDown = NULL;
}

CBaseButton::~CBaseButton() {
}

bool CBaseButton::CreateWnd(HWND ParentWnd, int x, int y, int w, int h) {

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CBaseButton::WindowProc;
	wcx.lpszClassName = L"CLASS_BUTTON";
	RegisterClassEx(&wcx);

	Width = w;
	Height = h;
	PosX = x;
	PosY = y;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_BUTTON", _T("Button"), WS_CHILD | WS_VISIBLE, x, y, Width, Height, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (LONG_PTR)this);

	return true;
}

LRESULT CBaseButton::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	CBaseButton* base_button = (CBaseButton*)GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (base_button != NULL)
		base_button->ButtonProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CBaseButton::ButtonProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {

	int x = 0;
	int y = 0;

	switch (message) {
	case WM_PAINT:
		OnPaint();
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_NCHITTEST:
		::SetFocus(m_hWnd);
		break;
	}

	return 0;
}

bool CBaseButton::SetImage(ID2D1Bitmap* normal_img, ID2D1Bitmap* down_img, ID2D1Bitmap* in_action_normal_img, ID2D1Bitmap* in_action_down_img) {

	Img_Normal = normal_img;
	Img_NormalMouseDown = down_img;
	Img_InActionNormal = in_action_normal_img;
	Img_InActionMouseDown = in_action_down_img;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////

void CBaseButton::OnPaint() {
}

//////////////////////////////////////////////////////////////////////////////////////////

bool CBaseButton::D2D1Draw(ID2D1HwndRenderTarget *render_target, int x, int y, int w, int h) {

	if (LButtonDown == true) {
		if (InAction == true) {
			if (Img_InActionMouseDown != NULL)
				render_target->DrawBitmap(Img_InActionMouseDown, D2D1::RectF(x, y, x + w, y + h), 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
		}
		else {
			if (Img_NormalMouseDown != NULL)
				render_target->DrawBitmap(Img_NormalMouseDown, D2D1::RectF(x, y, x + w, y + h), 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
		}
	}
	else {
		if (InAction == true) {
			if (Img_InActionNormal != NULL)
				render_target->DrawBitmap(Img_InActionNormal, D2D1::RectF(x, y, x + w, y + h), 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
		}
		else {
			if (Img_Normal != NULL)
				render_target->DrawBitmap(Img_Normal, D2D1::RectF(x, y, x + w, y + h), 1.0f, D2D1_BITMAP_INTERPOLATION_MODE_LINEAR);
		}
	}

	return true;
}

bool CBaseButton::Action() {

	InAction = true;

	if (ButtonID == BUTTON_TYPE_CLOSE)
		::SendMessage(theApp->MainWindow->m_hWnd, WM_CLOSE, 0, 0);
	if (ButtonID == BUTTON_TYPE_PLAY) 
		::SendMessage(theApp->MainWindow->ControlWnd->m_hWnd, WM_PLAY, 0, 0);
	
	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);

	return true;
}

bool CBaseButton::Stop() {

	InAction = false;

	if (ButtonID == BUTTON_TYPE_CLOSE)
		::SendMessage(theApp->MainWindow->m_hWnd, WM_CLOSE, 0, 0);
	if (ButtonID == BUTTON_TYPE_PLAY)
		::SendMessage(theApp->MainWindow->ControlWnd->m_hWnd, WM_PAUSE, 0, 0);

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);

	return true;
}

void CBaseButton::OnLButtonDown(UINT nFlags, CPoint point) {

	::SetCapture(m_hWnd);

	LButtonDown = true;

	::InvalidateRect(theApp->MainWindow->ControlWnd->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->ControlWnd->m_hWnd);
}

void CBaseButton::OnLButtonUp(UINT nFlags, CPoint point) {

	ReleaseCapture();

	if (LButtonDown == true) {
		if (InAction == true) {
			if (Stop() == true)
				InAction = false;
		}
		else {
			if (Action() == true)
				InAction = true;
		}
	}
	LButtonDown = false;

	::InvalidateRect(theApp->MainWindow->ControlWnd->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->ControlWnd->m_hWnd);
}
