Texture2D TexDiffuse[8] : register(t16);
SamplerState sampleDiffuse : register(s0);

Texture2D FieldTexture[16] : register(t32);

Texture2DArray<float> TexShadowMap : register(t48);

Texture2D DepthTexture : register( t3 );
Texture2D NoiseTexture : register( t4 );

cbuffer ConstantBuffer1 : register(b0) {

	matrix	MatView;
	matrix	MatProj;
	matrix	MatLight;
	matrix	MatProjLight[3];
	float4	LightColor[16];
	float4	LightPos[16];
	float4	EyePos;
	float4	CenterPos;
	float4	ShaderParam1;
	float4	ShaderParam2;
}

cbuffer ConstantBuffer2 : register(b1) {

	float4 Diffuse;
	float4 Ambient;
	float4 Specular;
	float4 AlphaParam;
	float4 TexParam1;
}

cbuffer ConstantBuffer3 : register(b2) {

	float4			ToneLightPos;
	matrix			BindShapeMatrix;
	matrix			MatTransform;
	matrix			MatNormalTransform;
	matrix			BoneMatrix[128];
}

cbuffer ConstantBuffer4 : register(b1) {

	float4			GridScale;
	float4			GridWidth;
	float4			GridColor;
	float4			GridColorSelected;
	float4			GridCursorPos;
}

cbuffer ConstantBuffer5 : register(b1) {

	float4			CursorPos;
	float4			CursorScale;
	float4			CursorWidth;
	float4			CursorColor;
}

cbuffer ConstantBuffer4 : register(b3) {

	float4 ColliderPos[255][2];
	float4 ColliderParam[255];
}

cbuffer ConstantBuffer5 : register(b4) {

	float4 ColliderState;
}

////////////////////////////////////////////////////////

struct VertexIn_1 {

	float4 Pos : POSITION;
	float4 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexIn_2 {

	float4 Pos : POSITION;
	float4 Normal : NORMAL;
	float2 Tex : TEXCOORD;
};

struct VertexIn_3 {

	float4 Pos : POSITION;
	float4 Normal : NORMAL;
	float2 Weight0 : TEXCOORD;
	float2 Weight1 : TEXCOORD1;
	float2 Weight2 : TEXCOORD2;
	float2 Weight3 : TEXCOORD3;
	float2 Weight4 : TEXCOORD4;
	float2 Weight5 : TEXCOORD5;
	float2 Weight6 : TEXCOORD6;
	float2 Weight7 : TEXCOORD7;
};

struct VertexIn_4 {

	float4 Pos : POSITION;
	float4 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
	float4 InstancePosition : INSTANCE_DATA0;
	float4 RenderParam : INSTANCE_DATA1;
	row_major float4x4 InstanceMatrix : INSTANCE_MATRIX;
	row_major float4x4 InstanceNormalMatrix : INSTANCE_NORMAL_MATRIX;
};

struct VertexOut {

	float4 Pos : SV_POSITION;
	float4 VtxPos : POSITION0;
	float4 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
	float4 CenterPosition : POSITION2;
	float4 RenderParam : RENDER_PARAM0;
};

struct VertexOutGS {

    float4 Pos : POSITION0;
    float4 VtxPos : POSITION1;
    float4 Normal : NORMAL0;
    float4 Color : COLOR0;
    float2 Tex : TEXCOORD0;
    float4 CenterPosition : POSITION2;
    uint   cascadeIndex : CASCADEINDEX;
};

struct ConstantHSOut {

	float Edge[3] : SV_TessFactor;
	float Inside : SV_InsideTessFactor;
};

struct PsInput {

	float4 Pos : SV_POSITION;
	float4 VtxPos : POSITION0;
	float4 ShadowTex : POSITION1;
	float4 Normal : NORMAL0;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsInput2 {

	float4 Pos : SV_POSITION;
	float4 VtxPos : POSITION0;
	float4 Normal : NORMAL0;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
	float4 CenterPosition : POSITION2;
	uint	cascadeIndex : SV_RenderTargetArrayIndex;
};

/////////////////////////////////////////////////////////////////////

uint rand(uint seed) {

	float arc = (float)seed / 1000000.0f;
	float random = frac(sin(dot(float2(arc, arc), float2(12.2653, 79.2531f))) * 26304.23) * 10000.0f;

	return (uint)(random) % 1000000;
}

VertexOut vs_main1(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	normal = mul( normal, MatNormalTransform );

	vtx = mul(vtx, MatTransform);
	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normalize( normal );

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOut vs_main2(VertexIn_2 IN) {

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos.xyz, 1.0f);
	OUT.Normal = float4( IN.Normal.xyz, 1.0 );
	OUT.VtxPos = IN.Pos;
	OUT.Tex = IN.Tex;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOut vs_main3(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	vtx.x *= GridScale.x;
	vtx.y *= GridScale.y;
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	normal = mul(normal, MatView);
	normal = mul(normal, MatProj);

	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;

	return OUT;
}

VertexOut vs_main4(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	vtx.xyz += CursorPos.xyz;
	vtx.x *= CursorScale.x;
	vtx.y *= CursorScale.y;
	float4 normal = float4(IN.Normal.xyz, 1.0f);

	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOut vs_main6(VertexIn_3 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul( normal, MatNormalTransform );

	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOutGS vs_main7(VertexIn_1 IN, uint instanceID : SV_InstanceID) {

	VertexOutGS OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul(normal, MatNormalTransform);
	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatLight);
	vtx = mul(vtx, MatProjLight[instanceID]);
	OUT.Pos = vtx;
	OUT.Normal = normal;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );
	OUT.cascadeIndex = instanceID;

	return OUT;
}

VertexOut vs_main8(VertexIn_2 IN) {

	//RC_[\p

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos.xyz, 1.0f);
	OUT.Normal = float4( IN.Normal.xyz, 1.0f );
	OUT.VtxPos = IN.Pos;
	OUT.Tex = IN.Tex;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOut vs_main9(VertexIn_3 IN) {

	//	LN^[RC_[\p

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal;
	OUT.CenterPosition = float4( 0, 0, 0, 0 );

	return OUT;
}

VertexOut vs_main10(VertexIn_4 IN) {

	//ʏIuWFNg@Rs[CX^X

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);

	normal = mul(normal, BindShapeMatrix);
	normal = mul(normal, IN.InstanceNormalMatrix);
	vtx = mul(vtx, BindShapeMatrix);
	vtx = mul(vtx, IN.InstanceMatrix);

	OUT.VtxPos = vtx;
	OUT.Pos = vtx;
	OUT.Normal = normalize( normal );

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;
	OUT.CenterPosition = IN.InstancePosition;
	OUT.RenderParam = IN.RenderParam;

	return OUT;
}

VertexOut vs_main11(VertexIn_4 IN) {

	//؂̗tρ@VhE}bv

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);

	normal = mul(normal, BindShapeMatrix);
	normal = mul(normal, IN.InstanceNormalMatrix);
	vtx = mul(vtx, BindShapeMatrix);
	vtx = mul(vtx, IN.InstanceMatrix);

	OUT.VtxPos = vtx;
	OUT.Pos = vtx;
	OUT.Normal = normal;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex = IN.Tex;
	OUT.CenterPosition = IN.InstancePosition;
	OUT.RenderParam = IN.RenderParam;

	return OUT;
}

VertexOut vs_main12(VertexIn_4 IN) {

	//ʏIuWFNg@Rs[CX^X

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);
	
	normal = mul(normal, BindShapeMatrix);
	normal = mul(normal, IN.InstanceNormalMatrix);
	vtx = mul(vtx, BindShapeMatrix);
	vtx = mul(vtx, IN.InstanceMatrix);

	OUT.VtxPos = vtx;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normalize( normal );

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;
	OUT.CenterPosition = IN.InstancePosition;
	OUT.RenderParam = IN.RenderParam;

	return OUT;
}

VertexOut vs_main13(VertexIn_4 IN) {

	//ʏIuWFNg@Rs[CX^Xiej

	VertexOut OUT;

	float4 vtx = float4(IN.Pos.xyz, 1.0f);
	float4 normal = float4(IN.Normal.xyz, 1.0f);

	normal = mul(normal, BindShapeMatrix);
	normal = mul(normal, IN.InstanceNormalMatrix);
	vtx = mul(vtx, BindShapeMatrix);
	vtx = mul(vtx, IN.InstanceMatrix);

	OUT.VtxPos = vtx;
	OUT.Pos = vtx;
	OUT.Normal = normalize( normal );

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;
	OUT.CenterPosition = IN.InstancePosition;
	OUT.RenderParam = IN.RenderParam;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////////////////////////

[maxvertexcount(3)]
void gs_main7(triangle VertexOutGS input[3], inout TriangleStream<PsInput2> triStream){

	PsInput2 vout;
	
	[unroll]
	for (int i = 0; i < 3; ++i) {
	
		vout.Pos = input[i].Pos;
		vout.VtxPos = input[i].VtxPos;
		vout.Normal = input[i].Normal;
		vout.Color = input[i].Color;
		vout.Tex = input[i].Tex;
		vout.CenterPosition = input[i].CenterPosition;
		vout.cascadeIndex = input[i].cascadeIndex;
		triStream.Append(vout);
		
	}
	triStream.RestartStrip();
}

ConstantHSOut ConstantHSMain(InputPatch<VertexOut, 3> ip, uint PatchID : SV_PrimitiveID) {

	ConstantHSOut OUT;

	OUT.Edge[0] = OUT.Edge[1] = OUT.Edge[2] = 1;
	OUT.Inside = 1;

	return OUT;
}

[domain("tri")]
[partitioning("integer")]
[outputtopology("triangle_cw")]
[outputcontrolpoints(3)]
[patchconstantfunc("ConstantHSMain")]
VertexOut hs_main10(InputPatch<VertexOut, 3> IN, uint i : SV_OutputControlPointID, uint PatchID : SV_PrimitiveID) {

	return IN[i];
}

[domain("tri")]
PsInput ds_main10(ConstantHSOut IN, float3 barycentric : SV_DomainLocation, const OutputPatch<VertexOut, 3 > patch) {

	//؂̗t

	PsInput OUT;

	OUT.Pos = float4(0, 0, 0, 0);
	OUT.VtxPos = float4(0, 0, 0, 0);
	OUT.ShadowTex = float4(0, 0, 0, 0);
	OUT.Normal = float4(0, 0, 0, 0);
	OUT.Color = float4(0, 0, 0, 0);
	OUT.Tex = float2(0, 0);

	OUT.Pos = float4( patch[0].Pos * barycentric.x + patch[1].Pos * barycentric.y + patch[2].Pos * barycentric.z );
	OUT.ShadowTex = OUT.Pos;

	OUT.Normal = float4( normalize( float3( patch[0].Normal.xyz * barycentric.x + patch[1].Normal.xyz * barycentric.y + patch[2].Normal.xyz * barycentric.z )), 0.0f );
	OUT.Tex = patch[0].Tex * barycentric.x + patch[1].Tex * barycentric.y + patch[2].Tex * barycentric.z;

	OUT.Color = float4( patch[0].Color * barycentric.x + patch[1].Color * barycentric.y + patch[2].Color * barycentric.z );

	float u1 = ShaderParam2.x + 0.32f; 
	float v1 = OUT.Pos.x * 100.0f;

	float u2 = ShaderParam2.x + 0.56f; 
	float v2 = OUT.Pos.y * 100.0f;

	float u3 = ShaderParam2.x + 0.13f; 
	float v3 = OUT.Pos.x * 150.0f + OUT.Pos.y * 150.0f;

	float4 noise_color1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1, v1 ), 0);
	float4 noise_color2 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2, v2 ), 0);
	float4 noise_color3 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u3, v3 ), 0);

	float u1_1 = ShaderParam2.y + 0.22f; 
	float v1_1 = OUT.Pos.x * 10.0f;

	float u2_1 = ShaderParam2.y + 0.66f; 
	float v2_1 = OUT.Pos.y * 10.0f;

	float u3_1 = ShaderParam2.y + 0.33f; 
	float v3_1 = OUT.Pos.x * 15.0f + OUT.Pos.y * 15.0f;

	float4 noise_color1_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1_1, v1_1 ), 0);
	float4 noise_color2_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2_1, v2_1 ), 0);
	float4 noise_color3_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u3_1, v3_1 ), 0);

	OUT.Pos.x += ( noise_color1.r - 0.7f ) * 2.0f + ( noise_color1_1.r - 0.7f ) * 2.0f;
	OUT.Pos.y += ( noise_color2.r - 0.7f ) * 2.0f + ( noise_color2_1.r - 0.7f ) * 2.0f;
	OUT.Pos.z += ( noise_color3.r - 0.7f ) * 2.0f + ( noise_color3_1.r - 0.7f ) * 2.0f;

	OUT.VtxPos = OUT.Pos;
	OUT.Pos = mul(OUT.Pos, MatView);
	OUT.Pos = mul(OUT.Pos, MatProj);

	return OUT;
}

[domain("tri")]
PsInput2 ds_main11(ConstantHSOut IN, float3 barycentric : SV_DomainLocation, const OutputPatch<VertexOut, 3 > patch) {

	//؂̗tρ@VhE}bv

	PsInput2 OUT;

	OUT.Pos = float4(0, 0, 0, 0);
	OUT.VtxPos = float4(0, 0, 0, 0);
	OUT.Normal = float4(0, 0, 0, 0);
	OUT.Color = float4(0, 0, 0, 0);
	OUT.Tex = float2(0, 0);

	OUT.Pos = float4( patch[0].Pos * barycentric.x + patch[1].Pos * barycentric.y + patch[2].Pos * barycentric.z );
	OUT.Normal = float4( normalize( float3( patch[0].Normal.xyz * barycentric.x + patch[1].Normal.xyz * barycentric.y + patch[2].Normal.xyz * barycentric.z )), 0.0f );
	OUT.Tex = patch[0].Tex * barycentric.x + patch[1].Tex * barycentric.y + patch[2].Tex * barycentric.z;
	OUT.Color = float4( patch[0].Color * barycentric.x + patch[1].Color * barycentric.y + patch[2].Color * barycentric.z );

	float u1 = ShaderParam2.x + 0.32f; 
	float v1 = OUT.Pos.x * 100.0f;

	float u2 = ShaderParam2.x + 0.56f; 
	float v2 = OUT.Pos.y * 100.0f;

	float u3 = ShaderParam2.x + 0.13f; 
	float v3 = OUT.Pos.x * 150.0f + OUT.Pos.y * 150.0f;

	float4 noise_color1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1, v1 ), 0);
	float4 noise_color2 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2, v2 ), 0);
	float4 noise_color3 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u3, v3 ), 0);

	float u1_1 = ShaderParam2.y + 0.22f; 
	float v1_1 = OUT.Pos.x * 10.0f;

	float u2_1 = ShaderParam2.y + 0.66f; 
	float v2_1 = OUT.Pos.y * 10.0f;

	float u3_1 = ShaderParam2.y + 0.33f; 
	float v3_1 = OUT.Pos.x * 15.0f + OUT.Pos.y * 15.0f;

	float4 noise_color1_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1_1, v1_1 ), 0);
	float4 noise_color2_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2_1, v2_1 ), 0);
	float4 noise_color3_1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u3_1, v3_1 ), 0);

	OUT.Pos.x += ( noise_color1.r - 0.7f ) * 2.0f + ( noise_color1_1.r - 0.7f ) * 2.0f;
	OUT.Pos.y += ( noise_color2.r - 0.7f ) * 2.0f + ( noise_color2_1.r - 0.7f ) * 2.0f;
	OUT.Pos.z += ( noise_color3.r - 0.7f ) * 2.0f + ( noise_color3_1.r - 0.7f ) * 2.0f;

	OUT.VtxPos = OUT.Pos;

	uint cascade_num = (uint) patch[0].RenderParam.x;
	OUT.cascadeIndex = cascade_num;

	OUT.Pos = mul(OUT.Pos, MatLight);
	OUT.Pos = mul(OUT.Pos, MatProjLight[cascade_num]);

	return OUT;
}

[domain("tri")]
PsInput ds_main14(ConstantHSOut IN, float3 barycentric : SV_DomainLocation, const OutputPatch<VertexOut, 3 > patch) {

	//

	PsInput OUT;

	OUT.Pos = float4(0, 0, 0, 0);
	OUT.VtxPos = float4(0, 0, 0, 0);
	OUT.ShadowTex = float4(0, 0, 0, 0);
	OUT.Normal = float4(0, 0, 0, 0);
	OUT.Color = float4(0, 0, 0, 0);
	OUT.Tex = float2(0, 0);

	OUT.Pos = float4( patch[0].Pos * barycentric.x + patch[1].Pos * barycentric.y + patch[2].Pos * barycentric.z );
	OUT.ShadowTex = OUT.Pos;

	OUT.Normal = float4( normalize( float3( patch[0].Normal.xyz * barycentric.x + patch[1].Normal.xyz * barycentric.y + patch[2].Normal.xyz * barycentric.z )), 0.0f );
	OUT.Tex = patch[0].Tex * barycentric.x + patch[1].Tex * barycentric.y + patch[2].Tex * barycentric.z;

	OUT.Color = float4( patch[0].Color * barycentric.x + patch[1].Color * barycentric.y + patch[2].Color * barycentric.z );

	float4 VtxCenter = float4( patch[0].CenterPosition * barycentric.x + patch[1].CenterPosition * barycentric.y + patch[2].CenterPosition * barycentric.z );
	float4 VtxPosition = float4( patch[0].VtxPos * barycentric.x + patch[1].VtxPos * barycentric.y + patch[2].VtxPos * barycentric.z );

	float u1 = ShaderParam2.x + 0.32f; 
	float v1 = VtxPosition.x * 0.01f;

	float u2 = ShaderParam2.x + 0.56f ; 
	float v2 = VtxPosition.y * 0.01f;

	float4 noise_color1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1, v1 ), 0);
	float4 noise_color2 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2, v2 ), 0);
	float len  = max( VtxPosition.z - VtxCenter.z, 0.0f );

	OUT.Pos.x += ( noise_color1.r - 0.7f ) * len * 0.7f;
	OUT.Pos.y += ( noise_color2.r - 0.7f ) * len * 0.7f;

	OUT.VtxPos = OUT.Pos;
	OUT.Pos = mul(OUT.Pos, MatView);
	OUT.Pos = mul(OUT.Pos, MatProj);

	return OUT;
}

[domain("tri")]
PsInput2 ds_main17(ConstantHSOut IN, float3 barycentric : SV_DomainLocation, const OutputPatch<VertexOut, 3 > patch) {

	// e

	PsInput2 OUT;

	OUT.Pos = float4(0, 0, 0, 0);
	OUT.VtxPos = float4(0, 0, 0, 0);
	OUT.Normal = float4(0, 0, 0, 0);
	OUT.Color = float4(0, 0, 0, 0);
	OUT.Tex = float2(0, 0);

	OUT.Pos = float4( patch[0].Pos * barycentric.x + patch[1].Pos * barycentric.y + patch[2].Pos * barycentric.z );

	OUT.Normal = float4( normalize( float3( patch[0].Normal.xyz * barycentric.x + patch[1].Normal.xyz * barycentric.y + patch[2].Normal.xyz * barycentric.z )), 0.0f );
	OUT.Tex = patch[0].Tex * barycentric.x + patch[1].Tex * barycentric.y + patch[2].Tex * barycentric.z;

	OUT.Color = float4( patch[0].Color * barycentric.x + patch[1].Color * barycentric.y + patch[2].Color * barycentric.z );

	float4 VtxCenter = float4( patch[0].CenterPosition * barycentric.x + patch[1].CenterPosition * barycentric.y + patch[2].CenterPosition * barycentric.z );
	float4 VtxPosition = float4( patch[0].VtxPos * barycentric.x + patch[1].VtxPos * barycentric.y + patch[2].VtxPos * barycentric.z );

	float u1 = ShaderParam2.x + 0.32f; 
	float v1 = VtxPosition.x * 0.01f;

	float u2 = ShaderParam2.x + 0.56f ; 
	float v2 = VtxPosition.y * 0.01f;

	float4 noise_color1 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u1, v1 ), 0);
	float4 noise_color2 = NoiseTexture.SampleLevel(sampleDiffuse, float2( u2, v2 ), 0);
	float len  = max( VtxPosition.z - VtxCenter.z, 0.0f );

	OUT.Pos.x += ( noise_color1.r - 0.7f ) * len * 0.7f;
	OUT.Pos.y += ( noise_color2.r - 0.7f ) * len * 0.7f;

	OUT.VtxPos = OUT.Pos;

	uint cascade_num = (uint) patch[0].RenderParam.x;
	OUT.cascadeIndex = cascade_num;

	OUT.Pos = mul(OUT.Pos, MatLight);
	OUT.Pos = mul(OUT.Pos, MatProjLight[cascade_num]);

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

float4 ps_main1(VertexOut input) : SV_Target0 {
	
	//fBt[YJ[̏o

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = float4( 0, 0, 0, 0 );
	
	tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);

	if( tex_color.a < 0.001f )
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.5f;
	float3 L = normalize( -LightPos[0].xyz - input.Normal.xyz );
	float3 N = normalize(input.Normal.xyz);
	float LN = (dot(L, N) + 1.0f) / 2.0f;
	float3 R = normalize(2 * LN * N - normalize(-LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb.rgb += tex_color.rgb * ambient_power;
	dif.rgb += LN * tex_color.rgb;
	spec.rgb += specular_power * pow(RV, 5.0);

	color.rgb = (dif.rgb + spec.rgb + amb.rgb);

	//JXP[hVhE}bv
	float shadow_area1 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 2000.0f, 0.0f, 1.0f );
	float shadow_area2 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 10000.0f, 0.0f, 1.0f );
	float shadow_area3 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 200000.0f, 0.0f, 1.0f );
	if( ShaderParam1.x >= 0.99f ){

			bool shadow = false;

			float count = 1.0f;
			float power = 1.0f;

			if( shadow_area1 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[0]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D = TexShadowMap.Sample(sampleDiffuse, float3( uv, 0 ));
				if ( D + 0.0005f < depth ){

					shadow = true;

					float r = 0.001f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;

						u1 = uv.x + r * 2.0f * sin( arg );
						v1 = uv.y + r * 2.0f * cos( arg );
						D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area2 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[1]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 1 ));
				if ( D1 + 0.0005f < depth ){

					shadow = true;

					float r = 0.0005f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 1 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area3 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[2]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 2 ));
				if ( D1 + 0.0001f < depth ){

					shadow = true;
					power = 1.0f;
				}
			}

			if( shadow == true )
				color.rgb /= max( 1.5f * shadow_area3 * power, 1.0f );
	}

	float dist = length( EyePos.xyz - input.VtxPos.xyz );
	color.rgb += pow( dist, 1.2f ) / 100000.0f;

	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	return color;
}

float4 ps_main1_1(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4(0, 0, 0, 0);
	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
	if (tex_color.a < 0.001f)
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.5f;
	float3 L = normalize(LightPos[0].xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - normalize(LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.5f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 1.4;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);

	float dist = length( EyePos.xyz - input.VtxPos.xyz );
	color.a = 100.0f / dist;

	return color;
}

float4 ps_main2(VertexOut input) : SV_Target0{

	//ŏIIȃ_O̍

	float4 tex_color = float4( 0, 0, 0, 0 );
	tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);

	return tex_color;
}

float4 ps_main3(VertexOut input) : SV_Target0{

	float grid_x = 1.0f / 200.0f;
	float grid_y = 1.0f / 200.0f;

	float4 grid_color = GridColor;

	float x1 = -5000.0f;
	float y1 = -5000.0f;
	float x2 = 5000.0f;
	float y2 = 5000.0f;
	float grid_size = ( x2 - x1 ) / 200.0f;
	int x_num = ( GridCursorPos.x + 5000.0f ) / grid_size;
	int y_num = ( GridCursorPos.y + 5000.0f ) / grid_size;
	int nx = abs( input.Tex.x / grid_x );
	int ny = abs( input.Tex.y / grid_y );
	if(( x_num == nx && y_num == ny ) 
	|| ( x_num + 1 == nx && y_num == ny && ( abs( input.Tex.x / grid_x ) - (int) abs( input.Tex.x / grid_x ) < 0.01f ))
	|| ( x_num == nx && y_num + 1 == ny && ( abs( input.Tex.y / grid_y ) - (int) abs( input.Tex.y / grid_y ) < 0.01f )))
		grid_color = GridColorSelected;

	float4 color = float4( 0, 0, 0, 0 );
	if( abs( input.Tex.x / grid_x ) - (int) abs( input.Tex.x / grid_x ) < 0.01f )
		color = grid_color;
	if( abs( input.Tex.y / grid_y ) - (int) abs( input.Tex.y / grid_y ) < 0.01f )
		color = grid_color;

	return color;
}

float4 ps_main4(VertexOut input) : SV_Target0{

	float4 color = float4( 0, 0, 0, 0 );
	float w1 = pow( CursorWidth.x, 4.0f ) * 0.00002f;
	float w2 = pow( CursorWidth.x - 0.3f, 4.0f ) * 0.00002f;
	float dist = sqrt( pow( input.Tex.x - 0.5f, 2.0f ) + pow( -input.Tex.y - 0.5f, 2.0f ));
	if( dist < w1 && dist > w2)	
		color = CursorColor;

	return color;
}

float4 ps_main5(VertexOut input) : SV_Target0{

	//If
	//fBt[YJ[̏o

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.001f )
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.5f;
	float4 light = float4( LightPos[0].xyz, 1.0f );
	float3 L = normalize(light.xyz);

	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - L);
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.5f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 1.4f;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);

	//FԂۂ
	color.r = 1.0f;
	color.g = clamp( color.g * 1.5f, 0.0f, 1.0f );
	color.b = clamp( color.b * 1.5f, 0.0f, 1.0f );
	color.a = tex_color.a;

	return color;
}

float4 ps_main6(VertexOut input) : SV_Target0{

	//bVRC_[\

	float4 color = float4(0, 0, 0, 0);
	float4 tex_color = float4( 0.8, 0.8, 0.8, 1.0f );

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 3.0f;
	float ambient_power = 1.0f;
	float3 L = normalize(float3( -1, -1, -1 ));
	float3 N = normalize(input.Normal.xyz);
	float LN = (dot(L, N) + 1.0f) / 2.0f;
	float3 R = normalize(2 * LN * N - normalize(float3( -1, -1, -1)));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.5f;
	spec += specular_power * pow(RV, 5.0);

	color.rgb = (amb.rgb + dif.rgb + spec.rgb) * tex_color.rgb;
	float len = sqrt( pow( EyePos.x - input.VtxPos.x, 2.0f ) + pow( EyePos.y - input.VtxPos.y, 2.0f ) + pow( EyePos.z - input.VtxPos.z, 2.0f ))  / 100.0f + 0.2f;
	color.rgb *= clamp( len, 0.1f, 0.8f );

	color.a = 1.0f;

	return color;
}

float ps_main7(PsInput2 input)  : SV_Target{

	//VhE}bv

	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);

/*	float tree_shading = ShaderParam1.w;
	if( tree_shading > 0.99f ){
	    float3 N = normalize(input.Normal);
	    float3 V = normalize(EyePos.xyz - input.VtxPos.xyz);
		float D = abs( dot( N, V ));
		float len = length( EyePos.xyz - input.VtxPos.xyz );
		if( tex_color.a > 0.5f )
			tex_color.a = D * 2.0f;
	}
*/
	float depth = input.Pos.z / input.Pos.w;

	return float4( 0, 0, 0, 0 );
}

/////////////////////////////////////////////////////////////////////////////

float4 dist_point_line(float4 p0, float4 p1, float4 pos) {

	float3 vec1 = pos.xyz - p0.xyz;
	float3 vec2 = p1.xyz - p0.xyz;
	float3 n_vec = normalize(vec2.xyz);
	float3 P = p0.xyz + dot(vec1.xyz, n_vec.xyz) * n_vec;
	float dist = length(pos.xyz - P.xyz);

	return float4(P.x, P.y, P.z, dist);
}

float4 dist_line_line(float4 p0, float4 p1, float4 pos0, float4 pos1) {

	float4 m1 = normalize(pos1 - pos0);
	float4 m2 = normalize(p1 - p0);

	float d = abs(dot(pos0.xyz - p0.xyz, cross(m1.xyz, m2.xyz))) / length(cross(m1.xyz, m2.xyz).xyz);

	float k = dot(m1.xyz - dot(m2.xyz, m1.xyz) * m2.xyz, p0.xyz - pos0.xyz) / (1.0f - pow(dot(m1.xyz, m2.xyz), 2.0f));
	float4 P1 = pos0 + k * m1;

	if (k > 0.0f && k < length(pos1.xyz - pos0.xyz)) {
		P1.w = d;
		return P1;
	}

	float4 P2 = dist_point_line(p0, p1, pos0);
	float4 P3 = dist_point_line(p0, p1, pos1);
	if (P2.w < P3.w)
		return P2;

	return P3;
}

float4 ps_main8(VertexOut input) : SV_Target0{

	//LN^[RC_[\

	float4 color = float4(0, 0, 0, 0);

	input.Tex.x = input.Tex.x * 2.0f - 1.0f;
	input.Tex.y = -input.Tex.y * 2.0f + 1.0f;

	float4 p0 = float4(input.Tex.x, input.Tex.y, -100, 0.0f);
	float4 p1 = float4(input.Tex.x, input.Tex.y, 100, 0.0f);

	for (int i = 0; i <= 254; i++) {

		int type = (int)(ColliderParam[i].x + 0.00001f);
		float r = ColliderParam[i].y;

		float4 pos1 = ColliderPos[i][0];
		float4 pos2 = ColliderPos[i][1];

		if (type == 0)
			break;
		else if (type == 1 || type == 2) {

			float4 d_pos = dist_point_line(p0, p1, pos1);
			if (d_pos.w < r) {
				color.r = 0.0f;
				color.g = 1.0f;
				color.b = 0.0f;
				color.a += 0.5f;
			}
		}
		else {
			float4 d_pos = dist_line_line(p0, p1, pos1, pos2);
			if (d_pos.w < r) {

				color.r = 0.0f;
				color.g = 0.0f;
				color.b = 1.0f;
				color.a += 0.5f;

				int state = (int) ColliderState.x;

				if( state == 1 ){
					color.r = 0.0f;
					color.g = 1.0f;
					color.b = 0.0f;
					color.a += 0.5f;
				}
				if( state == 2 ){
					color.r = 1.0f;
					color.g = 0.0f;
					color.b = 0.0f;
					color.a += 0.5f;
				}
			}
		}
	}
	color.a = min(color.a, 1.0f);

	return color;
}

float4 ps_main9(VertexOut input) : SV_Target0{

	//bVRC_[\

	float4 color = float4(0, 0, 1, 0.4);

	return color;
}

float4 ps_main10(PsInput input) : SV_Target0{

	//؂̗tρB

	float4 color = float4( 0, 0, 0, 0 );

	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.5f )
		discard;

	float3 N = normalize(input.Normal);
    float3 V = normalize(EyePos.xyz - input.VtxPos.xyz);
	float len = length( EyePos.xyz - input.VtxPos.xyz );
	float D = dot( N, V ) * 1.5f;
	tex_color.a = abs( D );

	float3 L = normalize( -LightPos[0].xyz * 100.0f - input.Normal.xyz );
	float LN = (dot(L, N) + 1.0f) / 2.0f ;

	if( LN > 0.9f )
		tex_color.rgb += 0.2f;

	if( LN < 0.4f )
		tex_color.rgb -= 0.2f;

	if( tex_color.a < 0.1f )
		discard;

	color = tex_color;

	//JXP[hVhE}bv
	float shadow_area1 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 2000.0f, 0.0f, 1.0f );
	float shadow_area2 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 10000.0f, 0.0f, 1.0f );
	float shadow_area3 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 200000.0f, 0.0f, 1.0f );
	if( ShaderParam1.x >= 0.99f ){

			bool shadow = false;

			float count = 1.0f;
			float power = 1.0f;

			if( shadow_area1 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[0]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D = TexShadowMap.Sample(sampleDiffuse, float3( uv, 0 ));
				if ( D + 0.0005f < depth ){

					shadow = true;

					float r = 0.001f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;

						u1 = uv.x + r * 2.0f * sin( arg );
						v1 = uv.y + r * 2.0f * cos( arg );
						D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area2 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[1]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 1 ));
				if ( D1 + 0.0005f < depth ){

					shadow = true;

					float r = 0.0005f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 1 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area3 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[2]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 2 ));
				if ( D1 + 0.0001f < depth ){

					shadow = true;
					power = 1.0f;
				}
			}

			if( shadow == true )
				color.rgb /= max( 1.5f * shadow_area3 * power, 1.0f );
	}

	return color;
}

float4 ps_main11(PsInput2 input) : SV_Target{

	//VhE}bv

	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.3f )
		discard;

	return float4( 0, 0, 0, 0 );
}

float4 ps_main14(PsInput input) : SV_Target0{

	//

	float4 color = float4( 0, 0, 0, 0 );

	float4 tex_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
	float4 noise_color = NoiseTexture.Sample(sampleDiffuse, input.VtxPos.xy * 0.006f);
	tex_color.r += ( noise_color.r - 0.5f ) * 0.2f;
	tex_color.rgb += ( noise_color.g - 0.5f ) * 0.3f;

	float specular_power = 0.3f;
	float ambient_power = 1.0f;
	float3 L = normalize( -LightPos[0].xyz - input.Normal.xyz );
	float3 N = normalize(input.Normal.xyz);
	float LN = (dot(L, N) + 1.0f) / 2.0f;
	float3 amb = tex_color.rgb * ambient_power;
	float3 spec = specular_power * pow(LN, 2.0);

	color.rgb = ( spec.rgb + amb.rgb);
	color.a = tex_color.a;

	color = clamp( color, 0.0f, 1.0f );

	return color;
}

float4 ps_main15(VertexOut input) : SV_Target0 {
	
	//Xvb^[}bvɂn\̕`

	float4 color = float4( 0, 0, 0, 0 );

	float alpha1 = 0.0f;
	float alpha2 = 0.0f;
	float alpha3 = 0.0f;
	float alpha4 = 0.0f;
	float alpha5 = 0.0f;
	float alpha6 = 0.0f;
	float alpha7 = 0.0f;
	float alpha8 = 0.0f;
	float alpha9 = 0.0f;

	float mag_1 = 3.0f;
	float mag_2 = 3.0f;
	float mag_3 = 6.0f;
	float mag_4 = 5.0f;
	float mag_5 = 5.0f;
	float mag_6 = 3.0f;
	float mag_7 = 1.0f;
	float mag_8 = 1.0f;
	float mag_9 = 1.0f;

	float4 texcolor1 = float4( 0, 0, 0, 0 );
	float4 texcolor2 = float4( 0, 0, 0, 0 );
	float4 texcolor3 = float4( 0, 0, 0, 0 );
	float4 texcolor4 = float4( 0, 0, 0, 0 );
	float4 texcolor5 = float4( 0, 0, 0, 0 );
	float4 texcolor6 = float4( 0, 0, 0, 0 );
	float4 texcolor7 = float4( 0, 0, 0, 0 );
	float4 texcolor8 = float4( 0, 0, 0, 0 );
	float4 texcolor9 = float4( 0, 0, 0, 0 );

	float4 blend_factor_1 = float4( 0, 0, 0, 0 );
	float4 blend_factor_2 = float4( 0, 0, 0, 0 );
	float4 blend_factor_3 = float4( 0, 0, 0, 0 );
	float4 decal_color = float4( 0, 0, 0, 0 );

	int splat_map_num = (int) TexParam1.x;
	int layout = (int) TexParam1.y;
	int decal_texture_num = (int) TexParam1.z;

	float4 texcolor = float4( 0, 0, 0, 0 );

	if( splat_map_num== 0 ){

		texcolor = TexDiffuse[0].Sample( sampleDiffuse, input.Tex );
	}
	else{

		if( decal_texture_num == 0 )
			decal_color = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 1 )
			decal_color = TexDiffuse[1].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 2 )
			decal_color = TexDiffuse[2].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 3 )
			decal_color = TexDiffuse[3].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 4 )
			decal_color = TexDiffuse[4].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 5 )
			decal_color = TexDiffuse[5].Sample(sampleDiffuse, input.Tex);
		else if( decal_texture_num == 6 )
			decal_color = TexDiffuse[6].Sample(sampleDiffuse, input.Tex);

		float3 normal = normalize( input.Normal.xyz );
		float3 blend_weight = pow( abs( normal ), 4.0f );
		blend_weight /= ( blend_weight.x + blend_weight.y + blend_weight.z );

		float2 uvX = input.VtxPos.yz * 0.01f;
		float2 uvY = input.VtxPos.zx * 0.01f;
		float2 uvZ = input.VtxPos.xy * 0.01f;


		if( splat_map_num >= 3 )
			blend_factor_3 = TexDiffuse[2].Sample(sampleDiffuse, input.Tex);
		if( splat_map_num >= 2 )
			blend_factor_2 = TexDiffuse[1].Sample(sampleDiffuse, input.Tex);
		if( splat_map_num >= 1 )
			blend_factor_1 = TexDiffuse[0].Sample(sampleDiffuse, input.Tex);

		alpha1 = blend_factor_1.r;
		alpha2 = blend_factor_1.g;
		alpha3 = blend_factor_1.b;
		alpha4 = blend_factor_2.r;
		alpha5 = blend_factor_2.g;
		alpha6 = blend_factor_2.b;
		alpha7 = blend_factor_3.r;
		alpha8 = blend_factor_3.g;
		alpha9 = blend_factor_3.b;

		if( layout == 0 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 6.0f;
			mag_4 = 5.0f;
			mag_5 = 3.0f;
			mag_6 = 3.0f;
			mag_7 = 3.0f;
			mag_8 = 1.0f;
			mag_9 = 2.0f;

			if( alpha1 > 0.01f )
				texcolor1 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[4].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}
		else if( layout == 1 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 3.0f;
			mag_4 = 5.0f;
			mag_5 = 6.0f;
			mag_6 = 5.0f;
			mag_7 = 3.0f;
			mag_8 = 2.0f;
			mag_9 = 1.0f;

			if( alpha1 > 0.01f )
				texcolor1 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}
		else if( layout == 2 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 6.0f;
			mag_4 = 5.0f;
			mag_5 = 3.0f;
			mag_6 = 3.0f;
			mag_7 = 5.0f;
			mag_8 = 1.0f;
			mag_9 = 2.0f;

			if( alpha1 > 0.01f )
				texcolor1 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[4].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}
		else if( layout == 3 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 6.0f;
			mag_4 = 5.0f;
			mag_5 = 3.0f;
			mag_6 = 3.0f;
			mag_7 = 3.0f;
			mag_8 = 2.0f;
			mag_9 = 1.0f;

			if( alpha1 > 0.01f )	
				texcolor1 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[4].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}
		else if( layout == 4 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 6.0f;
			mag_4 = 5.0f;
			mag_5 = 3.0f;
			mag_6 = 2.0f;
			mag_7 = 3.0f;
			mag_8 = 1.0f;
			mag_9 = 3.0f;

			if( alpha1 > 0.01f )
				texcolor1 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[4].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}
		else if( layout == 5 ){

			mag_1 = 3.0f;
			mag_2 = 3.0f;
			mag_3 = 2.0f;
			mag_4 = 5.0f;
			mag_5 = 3.0f;
			mag_6 = 6.0f;
			mag_7 = 3.0f;
			mag_8 = 1.0f;
			mag_9 = 3.0f;

			if( alpha1 > 0.01f )
				texcolor1 = FieldTexture[0].Sample( sampleDiffuse, uvX * mag_1) * blend_weight.x + FieldTexture[0].Sample( sampleDiffuse, uvY * mag_1) * blend_weight.y + FieldTexture[0].Sample( sampleDiffuse, uvZ * mag_1) * blend_weight.z;
			if( alpha2 > 0.01f )
				texcolor2 = FieldTexture[5].Sample( sampleDiffuse, uvX * mag_2) * blend_weight.x + FieldTexture[5].Sample( sampleDiffuse, uvY * mag_2) * blend_weight.y + FieldTexture[5].Sample( sampleDiffuse, uvZ * mag_2) * blend_weight.z;
			if( alpha3 > 0.01f )
				texcolor3 = FieldTexture[1].Sample( sampleDiffuse, uvX * mag_3) * blend_weight.x + FieldTexture[1].Sample( sampleDiffuse, uvY * mag_3) * blend_weight.y + FieldTexture[1].Sample( sampleDiffuse, uvZ * mag_3) * blend_weight.z;
			if( alpha4 > 0.01f )
				texcolor4 = FieldTexture[7].Sample( sampleDiffuse, uvX * mag_4) * blend_weight.x + FieldTexture[7].Sample( sampleDiffuse, uvY * mag_4) * blend_weight.y + FieldTexture[7].Sample( sampleDiffuse, uvZ * mag_4) * blend_weight.z;
			if( alpha5 > 0.01f )
				texcolor5 = FieldTexture[8].Sample( sampleDiffuse, uvX * mag_5) * blend_weight.x + FieldTexture[8].Sample( sampleDiffuse, uvY * mag_5) * blend_weight.y + FieldTexture[8].Sample( sampleDiffuse, uvZ * mag_5) * blend_weight.z;
			if( alpha6 > 0.01f )
				texcolor6 = FieldTexture[6].Sample( sampleDiffuse, uvX * mag_6) * blend_weight.x + FieldTexture[6].Sample( sampleDiffuse, uvY * mag_6) * blend_weight.y + FieldTexture[6].Sample( sampleDiffuse, uvZ * mag_6) * blend_weight.z;
			if( alpha7 > 0.01f )
				texcolor7 = FieldTexture[4].Sample( sampleDiffuse, uvX * mag_7) * blend_weight.x + FieldTexture[4].Sample( sampleDiffuse, uvY * mag_7) * blend_weight.y + FieldTexture[4].Sample( sampleDiffuse, uvZ * mag_7) * blend_weight.z;
			if( alpha8 > 0.01f )
				texcolor8 = FieldTexture[3].Sample( sampleDiffuse, uvX * mag_8) * blend_weight.x + FieldTexture[3].Sample( sampleDiffuse, uvY * mag_8) * blend_weight.y + FieldTexture[3].Sample( sampleDiffuse, uvZ * mag_8) * blend_weight.z;
			if( alpha9 > 0.01f )
				texcolor9 = FieldTexture[2].Sample( sampleDiffuse, uvX * mag_9) * blend_weight.x + FieldTexture[2].Sample( sampleDiffuse, uvY * mag_9) * blend_weight.y + FieldTexture[2].Sample( sampleDiffuse, uvZ * mag_9) * blend_weight.z;
		}

		float4 texcolor_1 = ( texcolor1 * alpha1 + texcolor2 * alpha2 + texcolor3 * alpha3 );
		float4 texcolor_2 = ( texcolor4 * alpha4 + texcolor5 * alpha5 + texcolor6 * alpha6 );
		float4 texcolor_3 = ( texcolor7 * alpha7 + texcolor8 * alpha8 + texcolor9 * alpha9 );

		float alpha = min( alpha1 + alpha2 + alpha3, 1.0f );
		texcolor = texcolor_1 + texcolor_2 * ( 1.0f - alpha );
		alpha = min( alpha1 + alpha2 + alpha3 + alpha4 + alpha5 + alpha6, 1.0f );
		texcolor = texcolor + texcolor_3 * ( 1.0f - alpha );

		texcolor = decal_color * decal_color.a + texcolor * ( 1.0f - decal_color.a );
		texcolor.a = 1.0f;
	}

	//////////////////////////////////////////////////////////////////////////////

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.3f;
	float3 L = normalize( -LightPos[0].xyz - input.Normal.xyz );
	float3 N = normalize(input.Normal.xyz);
	float LN = (dot(L, N) + 1.0f) / 2.0f;
	float3 R = normalize(2 * LN * N - normalize(-LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb.rgb += texcolor.rgb * ambient_power;
	dif.rgb += LN * texcolor.rgb;
	spec.rgb += specular_power * pow(RV, 3.0);

	//type1
	color.rgb = (dif.rgb + spec.rgb + amb.rgb);

	//type2
	//	color.rgb = amb.rgb * 3.0f; //vlooko[WFieldLowf̃eNX`Ƃɂ͂gĂB

	//JXP[hVhE}bv
	float shadow_area1 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 2000.0f, 0.0f, 1.0f );
	float shadow_area2 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 10000.0f, 0.0f, 1.0f );
	float shadow_area3 = clamp( 1.0f - pow( length( input.VtxPos.xyz - CenterPos.xyz ), 2.0f ) / 200000.0f, 0.0f, 1.0f );
	if( ShaderParam1.x >= 0.99f ){

			bool shadow = false;

			float count = 1.0f;
			float power = 1.0f;

			if( shadow_area1 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[0]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D = TexShadowMap.Sample(sampleDiffuse, float3( uv, 0 ));
				if ( D + 0.0005f < depth ){

					shadow = true;

					float r = 0.001f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;

						u1 = uv.x + r * 2.0f * sin( arg );
						v1 = uv.y + r * 2.0f * cos( arg );
						D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 0 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area2 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[1]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 1 ));
				if ( D1 + 0.0005f < depth ){

					shadow = true;

					float r = 0.0005f;
					for( float arg = 0.01f; arg < 3.14159265f * 2.0f; arg += 3.14159265f / 4.0f ){

						float u1 = uv.x + r * sin( arg );
						float v1 = uv.y + r * cos( arg );
						float D1 = TexShadowMap.Sample(sampleDiffuse, float3( u1, v1, 1 ));
						if ( D1 + 0.0005f < depth )
							power += 1.0f;
						count += 1.0f;
					}
					power /= count;
				}
			}
			else if( shadow_area3 > 0.01f ){

				float4 shadow_tex = mul(float4(input.VtxPos.xyz, 1.0f), MatLight);
				shadow_tex =  mul(shadow_tex, MatProjLight[2]);

				float2 uv = shadow_tex.xy;
				uv /= shadow_tex.w;
				uv.x = 0.5f * uv.x + 0.5f;
				uv.y = -0.5f * uv.y + 0.5f;

				float depth = shadow_tex.z / shadow_tex.w;
				float D1 = TexShadowMap.Sample(sampleDiffuse, float3( uv, 2 ));
				if ( D1 + 0.0001f < depth ){

					shadow = true;
					power = 1.0f;
				}
			}

			if( shadow == true )
				color.rgb /= max( 1.5f * shadow_area3 * power, 1.0f );
	}

	float dist = length( EyePos.xyz - input.VtxPos.xyz );
	color.rgb += pow( dist, 1.2f ) / 100000.0f;

	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = texcolor.a;


	///////////////////////////////////////////////////////
	//̃tB[h𓧉߂B
	//vlooko[Wł̓RgAEgĂB

	dist = max( length( EyePos.xyz - input.VtxPos.xyz ), 1.0f );
	color.a = min( 3.0f - pow( dist, 2.0f ) / 25000.0f, texcolor.a );

	///////////////////////////////////////////////////////

	return color;
}
