Texture2D TexDiffuse : register(t0);
SamplerState sampleDiffuse : register(s0);

Texture2D TexDepth : register(t1);
SamplerState sampleDepth : register(s1);

cbuffer ConstantBuffer1 : register(b0) {

	matrix	MatView;
	matrix	MatProj;
	matrix	MatViewShadowMap;
	matrix	MatProjShadowMap;
	matrix	MatLight;
	matrix	MatProjLight;
	float4	LightColor[16];
	float4	LightPos[16];
	float4	EyePos;
	float4	ShaderParam1;
}

cbuffer ConstantBuffer2 : register(b1) {

	float4 Diffuse;
	float4 Ambient;
	float4 Specular;
	float4 AlphaParam;
}

cbuffer ConstantBuffer3 : register(b2) {

	float4			ToneLightPos;
	matrix			BindShapeMatrix;
	matrix			MatTransform;
	matrix			MatNormalTransform;
	matrix			BoneMatrix[128];
}

cbuffer ConstantBuffer4 : register(b1) {

	float4			GridScale;
	float4			GridWidth;
	float4			GridColor;
	float4			GridColorSelected;
	float4			GridCursorPos;
}

cbuffer ConstantBuffer5 : register(b1) {

	float4			CursorPos;
	float4			CursorScale;
	float4			CursorWidth;
	float4			CursorColor;
}

////////////////////////////////////////////////////////

struct VertexIn_1 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float4 Color : COLOR;
	float2 Tex : TEXCOORD;
	float2 Weight0 : TEXCOORD1;
	float2 Weight1 : TEXCOORD2;
	float2 Weight2 : TEXCOORD3;
	float2 Weight3 : TEXCOORD4;
	float2 Weight4 : TEXCOORD5;
	float2 Weight5 : TEXCOORD6;
	float2 Weight6 : TEXCOORD7;
	float2 Weight7 : TEXCOORD8;
};

struct VertexIn_2 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float2 Tex : TEXCOORD;
};

struct VertexIn_3 {

	float3 Pos : POSITION;
	float3 Normal : NORMAL;
	float2 Weight0 : TEXCOORD;
	float2 Weight1 : TEXCOORD1;
	float2 Weight2 : TEXCOORD2;
	float2 Weight3 : TEXCOORD3;
	float2 Weight4 : TEXCOORD4;
	float2 Weight5 : TEXCOORD5;
	float2 Weight6 : TEXCOORD6;
	float2 Weight7 : TEXCOORD7;
};

struct VertexOut {

	float4 Pos : SV_POSITION;
	float3 VtxPos : POSITION0;
	float3 Normal : POSITION1;
	float4 Color : COLOR0;
	float2 Tex : TEXCOORD0;
};

struct PsOutput {

	float4 Color : SV_Target0;
	float4 Depth : SV_Target1;
};

/////////////////////////////////////////////////////////////////////

VertexOut vs_main1(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	normal = mul( normal, MatNormalTransform );

	vtx = mul(vtx, MatTransform);
	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normalize( normal.xyz );

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;

	return OUT;
}

VertexOut vs_main2(VertexIn_2 IN) {

	VertexOut OUT;

	OUT.Pos = float4(IN.Pos, 1.0f);
	OUT.Normal = IN.Normal;
	OUT.VtxPos = IN.Pos.xyz;
	OUT.Tex = IN.Tex;

	return OUT;
}

VertexOut vs_main3(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	vtx.x *= GridScale.x;
	vtx.y *= GridScale.y;
	float4 normal = float4(IN.Normal, 1.0f);
	normal = mul(normal, MatView);
	normal = mul(normal, MatProj);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;

	return OUT;
}

VertexOut vs_main4(VertexIn_1 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	vtx.xyz += CursorPos.xyz;
	vtx.x *= CursorScale.x;
	vtx.y *= CursorScale.y;
	float4 normal = float4(IN.Normal, 1.0f);

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	OUT.Color = float4(0, 0, 0, 1);
	OUT.Color = IN.Color;
	OUT.Tex.x = IN.Tex.x;
	OUT.Tex.y = -IN.Tex.y;

	return OUT;
}

VertexOut vs_main6(VertexIn_3 IN) {

	VertexOut OUT;

	float4 vtx = float4(IN.Pos, 1.0f);
	float4 normal = float4(IN.Normal, 1.0f);
	float4 vtx_tmp = float4(0, 0, 0, 0);
	float4 normal_tmp = float4(0, 0, 0, 0);

	vtx = mul(vtx, BindShapeMatrix);
	normal = mul(normal, BindShapeMatrix);

	int joint0 = (int)(IN.Weight0.x + 0.0001f);
	int joint1 = (int)(IN.Weight1.x + 0.0001f);
	int joint2 = (int)(IN.Weight2.x + 0.0001f);
	int joint3 = (int)(IN.Weight3.x + 0.0001f);
	int joint4 = (int)(IN.Weight4.x + 0.0001f);
	int joint5 = (int)(IN.Weight5.x + 0.0001f);
	int joint6 = (int)(IN.Weight6.x + 0.0001f);
	int joint7 = (int)(IN.Weight7.x + 0.0001f);

	float w0 = clamp(IN.Weight0.y, 0.0f, 1.0f);
	float w1 = clamp(IN.Weight1.y, 0.0f, 1.0f);
	float w2 = clamp(IN.Weight2.y, 0.0f, 1.0f);
	float w3 = clamp(IN.Weight3.y, 0.0f, 1.0f);
	float w4 = clamp(IN.Weight4.y, 0.0f, 1.0f);
	float w5 = clamp(IN.Weight5.y, 0.0f, 1.0f);
	float w6 = clamp(IN.Weight6.y, 0.0f, 1.0f);
	float w7 = clamp(IN.Weight7.y, 0.0f, 1.0f);

	bool add_weight = false;
	float4 v = float4(0, 0, 0, 0);
	float4 n = float4(0, 0, 0, 0);

	if (w0 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint0]);
		n = mul(normal, BoneMatrix[joint0]);
		v *= w0;
		n *= w0;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w1 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint1]);
		n = mul(normal, BoneMatrix[joint1]);
		v *= w1;
		n *= w1;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w2 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint2]);
		n = mul(normal, BoneMatrix[joint2]);
		v *= w2;
		n *= w2;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w3 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint3]);
		n = mul(normal, BoneMatrix[joint3]);
		v *= w3;
		n *= w3;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w4 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint4]);
		n = mul(normal, BoneMatrix[joint4]);
		v *= w4;
		n *= w4;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w5 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint5]);
		n = mul(normal, BoneMatrix[joint5]);
		v *= w5;
		n *= w5;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w6 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint6]);
		n = mul(normal, BoneMatrix[joint6]);
		v *= w6;
		n *= w6;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}
	if (w7 > 0.0000001f) {
		v = mul(vtx, BoneMatrix[joint7]);
		n = mul(normal, BoneMatrix[joint7]);
		v *= w7;
		n *= w7;
		vtx_tmp += v;
		normal_tmp += n;
		add_weight = true;
	}

	if (add_weight == true) {
		vtx = vtx_tmp;
		normal = normal_tmp;
	}

	vtx = mul(vtx, MatTransform);
	normal = mul( normal, MatNormalTransform );

	OUT.VtxPos = vtx.xyz;
	vtx = mul(vtx, MatView);
	vtx = mul(vtx, MatProj);
	OUT.Pos = vtx;
	OUT.Normal = normal.xyz;

	return OUT;
}

/////////////////////////////////////////////////////////////////////////

float4 ps_main1(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.001f )
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 1.8f;
	float ambient_power = 1.0f;
	float4 light = float4( LightPos[0].xyz, 1.0f );
	float3 L = normalize(light.xyz);

	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - L);
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.2f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);
	color.a = tex_color.a;

	return color;
}

float4 ps_main1_1(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4(0, 0, 0, 0);
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if (tex_color.a < 0.001f)
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.5f;
	float3 L = normalize(LightPos[0].xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - normalize(LightPos[0].xyz));
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.5f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 1.4;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);

	float dist = length( EyePos.xyz - input.VtxPos.xyz );
	color.a = 100.0f / dist;

	return color;
}

float4 ps_main2(VertexOut input) : SV_Target0{

	//ŏIIȃ_O̍

	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);

	return tex_color;
}

float4 ps_main3(VertexOut input) : SV_Target0{

	float grid_x = 1.0f / 200.0f;
	float grid_y = 1.0f / 200.0f;

	float4 grid_color = GridColor;

	float x1 = -5000.0f;
	float y1 = -5000.0f;
	float x2 = 5000.0f;
	float y2 = 5000.0f;
	float grid_size = ( x2 - x1 ) / 200.0f;
	int x_num = ( GridCursorPos.x + 5000.0f ) / grid_size;
	int y_num = ( GridCursorPos.y + 5000.0f ) / grid_size;
	int nx = abs( input.Tex.x / grid_x );
	int ny = abs( input.Tex.y / grid_y );
	if(( x_num == nx && y_num == ny ) 
	|| ( x_num + 1 == nx && y_num == ny && ( abs( input.Tex.x / grid_x ) - (int) abs( input.Tex.x / grid_x ) < 0.01f ))
	|| ( x_num == nx && y_num + 1 == ny && ( abs( input.Tex.y / grid_y ) - (int) abs( input.Tex.y / grid_y ) < 0.01f )))
		grid_color = GridColorSelected;

	float4 color = float4( 0, 0, 0, 0 );
	if( abs( input.Tex.x / grid_x ) - (int) abs( input.Tex.x / grid_x ) < 0.01f )
		color = grid_color;
	if( abs( input.Tex.y / grid_y ) - (int) abs( input.Tex.y / grid_y ) < 0.01f )
		color = grid_color;

	return color;
}

float4 ps_main4(VertexOut input) : SV_Target0{

	float4 color = float4( 0, 0, 0, 0 );
	float w1 = pow( CursorWidth.x, 4.0f ) * 0.00002f;
	float w2 = pow( CursorWidth.x - 0.3f, 4.0f ) * 0.00002f;
	float dist = sqrt( pow( input.Tex.x - 0.5f, 2.0f ) + pow( -input.Tex.y - 0.5f, 2.0f ));
	if( dist < w1 && dist > w2)	
		color = CursorColor;

	return color;
}

float4 ps_main5(VertexOut input) : SV_Target0{

	//fBt[YJ[̏o

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = TexDiffuse.Sample(sampleDiffuse, input.Tex);
	if( tex_color.a < 0.001f )
		tex_color = float4(Diffuse.r, Diffuse.g, Diffuse.b, Diffuse.a);

	float4 light_color = float4(0, 0, 0, 1);
	float4 dif = float4(0, 0, 0, 0);
	float4 amb = float4(0, 0, 0, 0);
	float4 spec = float4(0, 0, 0, 0);

	float specular_power = 0.1f;
	float ambient_power = 0.5f;
	float4 light = float4( LightPos[0].xyz, 1.0f );
	float3 L = normalize(light.xyz);

	float3 N = normalize(input.Normal.xyz);
	float LN = saturate(dot(L, N));
	float3 R = normalize(2 * LN * N - L);
	float3 V = normalize(EyePos.xyz);
	float RV = saturate(dot(R, V));
	amb += tex_color * ambient_power;
	dif += LN * tex_color * 1.5f;
	spec += specular_power * pow(RV, 5.0);

	float power = LightColor[0].w * 1.4f;

	light_color.rgb += power * LightColor[0].rgb;

	color.rgb = light_color.rgb * (amb.rgb + dif.rgb + spec.rgb);
	color.rgb = clamp(color.rgb, 0.0f, 1.0f);

	//FԂۂ
	color.r = 1.0f;
	color.g = clamp( color.g * 1.5f, 0.0f, 1.0f );
	color.b = clamp( color.b * 1.5f, 0.0f, 1.0f );
	color.a = tex_color.a;

	return color;
}

float4 ps_main6(VertexOut input) : SV_Target0{

	//RC_[\

	float4 color = float4( 0, 0, 0, 0 );
	float4 tex_color = float4( 0.3f, 0.3f, 1.0f, 0 );

	float4 dif = float4(0, 0, 0, 0);
	float4 light = float4( LightPos[0].xyz, 1.0f );
	float3 L = normalize(light.xyz);
	float3 N = normalize(input.Normal.xyz);
	float LN = (dot(L, N) + 1.0f ) / 2.0f;
	dif += LN * tex_color;

	color.rgb = dif.rgb;
	color.a = 1.0f;

	return color;
}

/////////////////////////////////////////////////////////////////////////////

float4 dist_point_line(float4 p0, float4 p1, float4 pos) {

	float3 vec1 = pos.xyz - p0.xyz;
	float3 vec2 = p1.xyz - p0.xyz;
	float3 n_vec = normalize(vec2.xyz);
	float3 P = p0.xyz + dot(vec1.xyz, n_vec.xyz) * n_vec;
	float dist = length(pos.xyz - P.xyz);

	return float4(P.x, P.y, P.z, dist);
}

float4 dist_line_line(float4 p0, float4 p1, float4 pos0, float4 pos1) {

	float4 m1 = normalize(pos1 - pos0);
	float4 m2 = normalize(p1 - p0);

	float d = abs(dot(pos0.xyz - p0.xyz, cross(m1.xyz, m2.xyz).xyz)) / length(cross(m1.xyz, m2.xyz).xyz);

	float k = dot(m1 - dot(m2, m1) * m2, p0 - pos0) / (1.0f - pow(dot(m1, m2), 2.0f));
	float4 P1 = pos0 + k * m1;

	if (k > 0.0f && k < length(pos1.xyz - pos0.xyz)) {
		P1.w = d;
		return P1;
	}

	float4 P2 = dist_point_line(p0, p1, pos0);
	float4 P3 = dist_point_line(p0, p1, pos1);
	if (P2.w < P3.w)
		return P2;

	return P3;
}

