/////////////////////////////////////////////////
//
//  filename: Skelton.cpp
//  author:Chafumi Touji
//  date: 2021/11/03 ver1.00
//
/////////////////////////////////////////////////

#include "Cha3D/defcha3d.h"
#include "Cha3DCore/defcha3dcore.h"
#include "ChaSound/ChaSound.h"
#include "Skelton.h"

CSkelton::CSkelton() : CCharacterBase() {

	Move = false;

	Audio = NULL;
	AudioPlaying = false;
	RotAction = false;
	KeyDown = false;

	memset( BackCollisionZ, 0, sizeof( float) * 10 );
}

CSkelton::CSkelton(CDispWindow* disp_window) : CCharacterBase(disp_window) {

	Move = false;
	DispWindow = disp_window;
}

CSkelton::~CSkelton() {

}

void CSkelton::OnKeyDown(BYTE *key) {

	if (RotAction == true)
		return;

	KeyDown = false;

	if (key[DIK_LEFT] & 0x80 /*  */) {

		KeyDown = true;

		RotationZ += 1.0f;

		if (RotationZ > 360.0f)
			RotationZ -= 360.0f;
		if (RotationZ < 0.0f)
			RotationZ += 360.0f;

		BackRotationZ = RotationZ;
	}
	if (key[DIK_UP] & 0x80 /*  */) {

		KeyDown = true;

		BackRotationZ = RotationZ - 180.0f;
		if (BackRotationZ > 360.0f)
			BackRotationZ -= 360.0f;
		if (BackRotationZ < 0.0f)
			BackRotationZ += 360.0f;

		if (Move == false) {
			SetCurrentAnimation(L"WALK", 5, 10, true, false);
		}
		Move = true;
	}
	if (key[DIK_RIGHT] & 0x80 /*  */) {
		RotationZ -= 1.0f;

		KeyDown = true;

		if (RotationZ > 360.0f)
			RotationZ -= 360.0f;
		if (RotationZ < 0.0f)
			RotationZ += 360.0f;

		BackRotationZ = RotationZ;
	}
	if (key[DIK_DOWN] & 0x80 /*  */) {

		KeyDown = true;

		if( RotationZ > 180.0f)
			BackRotationZ = RotationZ - 180.0f;
		else
			BackRotationZ = RotationZ + 180.0f;

		RotAction = true;
	}
}

void CSkelton::PreAction() {

	if (RotAction == true) {
		if (RotationZ - BackRotationZ < 0.0f)
			RotationZ += 2.0f;
		else
			RotationZ -= 2.0f;

		if (abs(RotationZ - BackRotationZ) < 20.0f) {
			RotationZ = BackRotationZ;
			RotAction = false;
		}

		return;
	}
	if (Move == true) {

		XMFLOAT4 rotation = GetRotation();

		SetRotation(XMFLOAT4(0, 0, RotationZ + 90.0f, 0));
		rotation = GetRotation();

		AddVelocity(0.02f);
		if (GetVelocity() >= 1.0f)
			SetVelocity(1.0f);

		XMVECTOR vec = XMVector3Normalize(XMVectorSet(cos(ToRadian(RotationZ)), sin(ToRadian(RotationZ)), 0.0f, 1.0f));
		SetVector(XMFLOAT4(XMVectorGetX(vec) * GetVelocity(), XMVectorGetY(vec) * GetVelocity(), 0, 0));

		XMFLOAT4 vec2 = GetVector();
		AddPosition(XMFLOAT4(vec2.x, vec2.y, 0, 0));
	}

	XMFLOAT4 pos = GetPosition();
	XMFLOAT4 cross_pos = XMFLOAT4(0, 0, 0, 0);
	bool collision = DispWindow->ObjectManager->GetFieldCollisionPoint( XMFLOAT4( pos.x / 2000.0f, pos.y / 2000.0f, 0.0f, 0.0f ), &cross_pos );
	if( collision == true)
		SetPosition(XMFLOAT4( pos.x, pos.y, cross_pos.z * 2000.0f, 0.0f));

	DispWindow->Camera->SetLightPos(10000, 10000, 6000);
	DispWindow->Camera->SetLightAt(0, 0, 0);

	DispWindow->Camera->SetShadowLightPos(100 + pos.x, 100 + pos.y, 60 + pos.z);
	DispWindow->Camera->SetShadowAt(pos.x, pos.y, pos.z);

	DispWindow->Camera->SetLightPower(0.7f);
}

void CSkelton::Action() {

	XMFLOAT4 pos = GetPosition();

	for (int i = 1; i <= 9; i++) {
		BackCollisionZ[i - 1] = BackCollisionZ[i];
	}
	BackCollisionZ[9] = pos.z;

	float ave_z = 0.0f;
	for (int i = 0; i <= 9; i++)
		ave_z += BackCollisionZ[i];
	ave_z /= 10.0f;

	//JZbg
	DispWindow->Camera->SetCameraAt(pos.x, pos.y, ave_z);

	XMVECTOR vec = XMVector3Normalize(XMVectorSet(cos(ToRadian(RotationZ)), sin(ToRadian(RotationZ)), 0.0f, 1.0f));
	SetVector(XMFLOAT4(XMVectorGetX(vec) * ( GetVelocity() * 20.0f + 20.0f), XMVectorGetY(vec) * ( GetVelocity() * 20.0f + 20.0f) , 20.0f - GetVelocity() * 15.0f, 0));

	XMFLOAT4 vec2 = GetVector();

	DispWindow->Camera->SetEyePos(pos.x - vec2.x, pos.y - vec2.y, ave_z + vec2.z);

	ChaResourceObject->UpdateTransform();
	ChaColliderObject->Transform();

	if (KeyDown == false) {
		if (Move == true) {
			SetCurrentAnimation(L"STAND", 5, 3, true, false);
			SetRefrainSec(L"STAND", 0.0f);
		}

		Move = false;

		AddVelocity(-0.02f);
		if (GetVelocity() < 0.0f)
			SetVelocity(0.0f);
	}
}

