////////////////////////////////////////////////////////
// filename: defcha3d.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2021/06/30
////////////////////////////////////////////////////////

#ifndef __DEFCHA3D_H__
#define __DEFCHA3D_H__

#define _XM_NO_INTRINSICS_

#define SIZE_CHAR_MAX	1024
#define SIZE_CBV_SRV_UAV_ARRAY		2000
#define FULLHD_WIDTH		1920
#define FULLHD_HEIGHT		1080

#include <Windows.h>
#include <windowsx.h>
#include <atlimage.h>
#include <locale.h>
#include <atlstr.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdiplus.h>
#include <Richedit.h>
#include <tchar.h>
#include <stdint.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>

#include <imm.h>
#pragma comment(lib, "imm32.lib")

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#include <d3d12.h>
#include <dxgi1_4.h>
#include <D3Dcompiler.h>
#include <math.h>
#include <DirectXMath.h>

#include <wrl.h>

#pragma comment(lib, "d3d12.lib")
#pragma comment(lib, "dxgi.lib")
#pragma comment(lib, "d3dcompiler.lib")
#pragma comment(lib, "windowscodecs.lib")
#pragma comment(lib, "dxguid.lib")

#include <dinput.h>
#pragma comment(lib, "dinput8.lib")
#pragma comment(lib, "dxguid.lib")

using Microsoft::WRL::ComPtr;
using namespace DirectX;
using namespace Gdiplus;

#define SAFE_RELEASE(p) { if( p ) { (p)->Release(); (p) = NULL;}}

//////////////////////////////////////////////////////

#include "Cha3DCore/defcha3dcore.h"
#pragma comment( lib, "Cha3DCoreLib1.14.6.lib")

#include "CListA.h"
#include "CCommonDevice.h"
#include "CameraBase.h"
#include "DispWindow.h"
#include "CharacterBase.h"
#include "ObjectManager.h"

#endif