/////////////////////////////////////////////////
//
//  filename: ObjectManager.h
//  author:Chafumi Touji
//  date: 2021/07/03 ver1.00
//
/////////////////////////////////////////////////

#ifndef __OBJECTMANAGER_H__
#define __OBJECTMANAGER_H__

class CObjectManager {
public:

	CCommonDevice* Device;
	CDispWindow* DispWindow;

	bool DrawCollider;

	CListA* CharacterList;
	CListA* ObjectList;
	CListA* FieldList;

public:
	CObjectManager();
	CObjectManager(CCommonDevice* device, CDispWindow *disp_window);
	~CObjectManager();
	bool AddCharacter(const wchar_t* filename, const wchar_t* id, CCharacterBase *obj, int64_t swap_id, bool is_animated );
	bool AddSwapCharacter(const wchar_t* filename, const wchar_t* id, int64_t swap_id, bool is_animated);
	bool AddAnimation(const wchar_t* filename, const wchar_t* anim_id, const wchar_t *id, int64_t swap_id  );
	bool AddObject(const wchar_t* filename, const wchar_t* id, CCharacterBase *obj, int64_t swap_id, bool is_animated  );
	bool AddField(const wchar_t* filename, const wchar_t* id, CCharacterBase* obj, int64_t swap_id, bool is_animated);
	bool AddSwapObject(const wchar_t* filename, const wchar_t* id, int64_t swap_id, bool is_animated );
	bool CopyAnimation(const wchar_t* id);
	bool CopyCharacter(const wchar_t* origin_id, const wchar_t* id);
	bool CopyObject(const wchar_t* origin_id, const wchar_t* id);
	CCharacterBase* GetCharacterData(const wchar_t* id);
	XMFLOAT4 GetScaling(const wchar_t* id);
	bool SetScaling(const wchar_t* id, XMFLOAT4 scale);
	bool AddScaling(const wchar_t* id, XMFLOAT4 scale);
	XMFLOAT4 GetRotation(const wchar_t* id);
	bool SetRotation(const wchar_t* id, XMFLOAT4 rot);
	bool AddRotation(const wchar_t* id, XMFLOAT4 rot);
	XMFLOAT4 GetPosition(const wchar_t* id);
	bool SetPosition(const wchar_t* id, XMFLOAT4 point);
	bool AddPosition(const wchar_t* id, XMFLOAT4 point);
	XMFLOAT4 GetVector(const wchar_t* id);
	bool SetVector(const wchar_t* id, XMFLOAT4 vec);
	bool AddVector(const wchar_t* id, XMFLOAT4 vec);
	float GetVelocity(const wchar_t* id);
	bool SetVelocity(const wchar_t* id, float velocity);
	bool AddVelocity(const wchar_t* id, float velocity);
	bool DeleteCharacter(const wchar_t* id);
	bool DeleteObject(const wchar_t* id);
	bool DeleteField(const wchar_t* id);
	bool PreAction();
	bool Action();
	bool DrawCharacter(ID3D12GraphicsCommandList* cmd_list);
	bool DrawObject(ID3D12GraphicsCommandList* cmd_list);
	bool DrawField(ID3D12GraphicsCommandList* cmd_list);
	bool DrawCharacterCollider();
	bool DrawObjectCollider();
	bool UpdateFrameCount(int count);
	bool UpdateTransform();
	void OnKeyDown(BYTE *key);
	bool GetFieldCollisionPoint( XMFLOAT4 pos, XMFLOAT4 *cross_pos );
};

#endif