/////////////////////////////////////////////////
//
//  filename: DispWindow.h
//  author:Chafumi Touji
//  date: 2021/06/30 ver1.00
//
/////////////////////////////////////////////////

#ifndef __DISPWINDOW_H__
#define __DISPWINDOW_H__

class CObjectManager;

class CDispWindow {
public:

	CCommonDevice* Device;
	CObjectManager* ObjectManager;
	CCameraBase* Camera;

	wchar_t						Path[SIZE_CHAR_MAX];
	XMFLOAT4					BKColor;

	HWND			m_hWnd;
	UINT			TimerID;
	int				UpdateFrameCount;

	HANDLE			m_hThread1, m_hThread2;

	int				Width, Height;
	int				ResolutionWidth, ResolutionHeight;

	bool			AppExit;

	bool			IsFullScreen;
	bool			BackFullScreen;
	bool			IsTransparent;
	int				TransparentR, TransparentG, TransparentB;

	bool			LButtonDown;
	bool			RButtonDown;
	CPoint			DownPoint;

	double					FPS;
	LARGE_INTEGER			mTimeFreq;
	LARGE_INTEGER			mTimeStart;
	LARGE_INTEGER			mTimeEnd;

public:
	CDispWindow();
	~CDispWindow();
	bool CreateWnd(HWND parent_wnd, int x, int y, int w, int h);
	bool Run();
	bool Draw(CObjectManager* manager, D3D12_CPU_DESCRIPTOR_HANDLE handle_rtv, D3D12_CPU_DESCRIPTOR_HANDLE handle_dsv);
	bool DrawShadowMap( CObjectManager *manager, D3D12_CPU_DESCRIPTOR_HANDLE handle_rtv, D3D12_CPU_DESCRIPTOR_HANDLE handle_dsv);
	bool Render( CObjectManager *manager );
	bool Render1(CObjectManager* manager);
	bool Render2(CObjectManager* manager);
	bool Render3(CObjectManager* manager);
	bool CheckCollision(CObjectManager* manager);
	bool DrawCollider(bool draw);
	static unsigned CallbackProc1(void* param);
	static unsigned CallbackProc2(void* param);
	static unsigned RenderProc1(void* param);
	static unsigned RenderProc2(void* param);
	static unsigned RenderProc3(void* param);

public:
	void OnSize(UINT nType, int cx, int cy);
	void WaitForGPU();

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT DispWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);
};

#endif
