/////////////////////////////////////////////////
//
//  filename: CameraBase.cpp
//  author:Chafumi Touji
//  date: 2021/07/30 ver1.00
//
/////////////////////////////////////////////////

#ifndef __CAMERABASE_H__
#define __CAMERABASE_H__

class CCameraBase {
public:

	int				Width;
	int				Height;
	float			Aspect;
	float			ViewAngle;

	float			Zoom;
	float			CameraHeight;

	float			RotationX;
	float			RotationY;
	float			RotationZ;

	float			LightPosX;
	float			LightPosY;
	float			LightPosZ;
	float			LightPower;

	float			LightAtX;
	float			LightAtY;
	float			LightAtZ;

	float			ShadowLightPosX;
	float			ShadowLightPosY;
	float			ShadowLightPosZ;

	float			ShadowAtX;
	float			ShadowAtY;
	float			ShadowAtZ;

	float			EyeX;
	float			EyeY;
	float			EyeZ;

	float			AtX;
	float			AtY;
	float			AtZ;

	float			EyePosX;
	float			EyePosY;
	float			EyePosZ;

public:

	CCameraBase();
	CCameraBase( int width, int height );
	~CCameraBase();
	bool SetCamera( CCommonDevice *device );
	bool SetCameraforShadowMap(CCommonDevice* device);
	bool SetEyePos(float x, float y, float z);
	bool SetCameraAt(float x, float y, float z);
	bool SetCameraRot(float x, float y, float z);
	bool SetLightPos(float x, float y, float z);
	bool SetLightAt(float x, float y, float z);
	bool SetLightPower(float power);
	bool SetShadowLightPos(float x, float y, float z);
	bool SetShadowAt(float x, float y, float z);
	bool SetZoom(float zoom);
};

#endif