/////////////////////////////////////////////////
//
//  filename: MenuWindow.h
//  author:Chafumi Touji
//  date: 2020/06/03 ver1.00
//
/////////////////////////////////////////////////

#ifndef __MENUWINDOW_H__
#define __MENUWINDOW_H__

class CButtonModelOpen;
class CButtonModelWrite;
class CButtonAnimOpen;
class CButtonAnimWrite;
class CButtonColliderWrite;
class CAnimationListWindow;
class CScrollBar;

class CMenuWindow{
public:

	HWND	m_hWnd;

	wchar_t Path[SIZE_CHAR_MAX];
	int Width, Height;
	int DisplayWidth, DisplayHeight;
	int TitleBarHeight;
	int TaskBarHeight;
	float ScaleX, ScaleY;
	float dpiX, dpiY;
	int FrameEdgeX, FrameEdgeY;
	int TransparentR, TransparentG, TransparentB;

	char			*AlphaBMP;
	HDC				MemDC;
	HBITMAP			MemBMP;
	int				BitmapWidth;
	int				BitmapHeight;

	int PosX, PosY;
	int BKColorR, BKColorG, BKColorB, BKColorA;
	int TextColorR, TextColorG, TextColorB, TextColorA;
	CPoint DownPoint;
	bool LButtonDown;
	bool RButtonDown;

	CAnimationListWindow 	*AnimationListWnd;

	CButtonModelOpen	*ButtonModelOpen;
	CButtonModelWrite	*ButtonModelWrite;
	CButtonAnimOpen		*ButtonAnimOpen;
	CButtonAnimWrite	*ButtonAnimWrite;
	CButtonColliderWrite	*ButtonColliderWrite;

public:
	CMenuWindow();
	~CMenuWindow();
	bool SetParam(CConfig *config);
	bool GetParam(CConfig *config);
	bool CreateWnd(HWND parent, int x, int y, int w, int h);
	bool OnDraw( HDC hdc );

private:
	void OnPaint();
	void OnKeyDown(UINT nChar);
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnRButtonDown(UINT nFlag, CPoint point);
	void OnRButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnMouseWheel(UINT key, int delta, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT MenuWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CAnimationListWindow{
public:

	HWND m_hWnd;

	CScrollBar	*ScrollV;

	int DisplayWidth, DisplayHeight;
	int PosX, PosY, Width, Height;
	int BKColorA, BKColorR, BKColorG, BKColorB;
	int TextColorA, TextColorR, TextColorG, TextColorB;
	int SelectedNum;

	float ScaleX, ScaleY;
	float dpiX, dpiY;

	int ItemCountMax;
	int ItemBegin;
	int ItemHeight;
	int IconSize;
	int ItemCount;

	CPoint DownPoint;
	bool LButtonDown;

	HDC				MemDC;
	HBITMAP			MemBMP;

public:
	CAnimationListWindow();
	~CAnimationListWindow();
	bool SetParam(CConfig *config);
	bool CreateWnd(HWND ParentWnd, int x, int y, int w, int h, HDC memDC, HBITMAP bitmap);
	bool OnDraw(HDC hdc);
	bool DrawItem(Gdiplus::Graphics *gfc);
	int SelectItem(CPoint point);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);
	void OnMouseWheel(UINT nFlag, int zDelta, CPoint point);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT AnimationListWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

#endif