/////////////////////////////////////////////////
//
//  filename: CustomButton.h
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#ifndef __CUSTOMBUTTON_H__
#define __CUSTOMBUTTON_H__

class CCustomButton{
public:

	HWND	m_hWnd;

	int	PosX, PosY;
	int FrameEdgeX, FrameEdgeY;
	int	Width, Height;
	int BKColorA, BKColorR, BKColorG, BKColorB;
	bool LButtonDown;

	Gdiplus::Image *ButtonImage;
	Gdiplus::Image *ButtonDownImage;

	CCustomButton();
	~CCustomButton();
	bool CreateWnd(int x, int y, int w, int h, HWND ParentWnd);
	virtual bool Action();
	bool OnDraw(HDC hdc);
	bool OnDraw(HDC hdc, int pos_x, int pos_y, int width, int height );
	bool SetImage(const wchar_t *button_img_path, const wchar_t *button_down_img_path);
	bool SetColor(int a, int r, int g, int b);

public:
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnPaint();

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT CustomButtonWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CButtonClose : public CCustomButton{
public:

	CButtonClose(){};
	~CButtonClose(){};
	bool Action();
};

class CButtonDialogClose : public CCustomButton{
public:

	CButtonDialogClose(){};
	~CButtonDialogClose(){};
	bool Action();
};

class CButtonMinimize : public CCustomButton{
public:

	CButtonMinimize(){};
	~CButtonMinimize(){};
	bool Action();
};

class CButtonMaximize : public CCustomButton{
public:

	CButtonMaximize(){};
	~CButtonMaximize(){};
	bool Action();
};

class CButtonModelOpen : public CCustomButton{
public:

	CButtonModelOpen(){};
	~CButtonModelOpen(){};
	bool Action();
};

class CButtonModelWrite : public CCustomButton{
public:

	CButtonModelWrite(){};
	~CButtonModelWrite(){};
	bool Action();
};

class CButtonAnimOpen : public CCustomButton{
public:

	CButtonAnimOpen(){};
	~CButtonAnimOpen(){};
	bool Action();
};

class CButtonAnimWrite : public CCustomButton{
public:

	CButtonAnimWrite(){};
	~CButtonAnimWrite(){};
	bool Action();
};

class CButtonColliderWrite : public CCustomButton {
public:

	CButtonColliderWrite() {};
	~CButtonColliderWrite() {};
	bool Action();
};

class CButtonDir : public CCustomButton{
public:

	CButtonDir(){};
	~CButtonDir(){};
	bool Action();
};

class CButtonCancel : public CCustomButton{
public:

	CButtonCancel(){};
	~CButtonCancel(){};
	bool Action();
};

class CButtonOK : public CCustomButton{
public:

	CButtonOK(){};
	~CButtonOK(){};
	bool Action();
};

class CButtonConfirmClose : public CCustomButton{
public:

	CButtonConfirmClose(){};
	~CButtonConfirmClose(){};
	bool Action();
};

class CButtonConfirmCancel : public CCustomButton{
public:

	CButtonConfirmCancel(){};
	~CButtonConfirmCancel(){};
	bool Action();
};

class CButtonConfirmOK : public CCustomButton{
public:

	CButtonConfirmOK(){};
	~CButtonConfirmOK(){};
	bool Action();
};

#endif