/////////////////////////////////////////////////
//
//  filename: Config.h
//  author:Chafumi Touji 
//  date: 2020/03/13 ver1.00
//
/////////////////////////////////////////////////

#ifndef __CONFIG_H__
#define __CONFIG_H__

class CConfig{
public:

	float	RotationX, RotationZ;
	float	LightPosX, LightPosY, LightPosZ;
	int		BKColorA, BKColorR, BKColorG, BKColorB;
	int		TextColorA, TextColorR, TextColorG, TextColorB;
	int		BarColorA, BarColorR, BarColorG, BarColorB;
	int		ViewerBKColorA, ViewerBKColorR, ViewerBKColorG, ViewerBKColorB;
	int		MenuBKColorA, MenuBKColorR, MenuBKColorG, MenuBKColorB;
	int		MenuTextColorA, MenuTextColorR, MenuTextColorG, MenuTextColorB;

	wchar_t		Path[SIZE_CHAR_MAX];
	wchar_t		ExtModel[SIZE_CHAR_MAX];
	wchar_t		ExtAnim[SIZE_CHAR_MAX];
	wchar_t		ExtDae[SIZE_CHAR_MAX];
	wchar_t		ExtCdr[SIZE_CHAR_MAX];

	CConfig();
	~CConfig();

public:
	bool GetParamI( int *value, const char *name, char *param1, char *param2);
	bool GetParamF(float *value, const char *name, char *param1, char *param2);
	bool GetParamB(bool *value, const char *name, char *param1, char *param2);
	bool GetParamS(wchar_t *str, const char *name, char *param1, char *param2);
	bool WriteParamI(FILE *file, const char *param1, int value);
	bool WriteParamF(FILE *file, const char *param1, float value);
	bool WriteParamB(FILE *file, const char *param1, bool value);
	bool WriteParamS(FILE *file, const char *param1, wchar_t *str);
	bool LoadConfigFile(const wchar_t *filename);
	bool WriteConfigFile(const wchar_t *filename);
};

#endif