////////////////////////////////////////////////////////
// filename: ResManager.h
// author: Chafumi Touji
// version: 1.0.0
// date: 2021/03/11
////////////////////////////////////////////////////////

#ifndef __RESMANAGER_H__
#define __RESMANAGER_H__

class CResManager {
public:

	byte		ResArray[SIZE_CBV_SRV_UAV_ARRAY];
	int64_t		CPUHandle[SIZE_CBV_SRV_UAV_ARRAY];

	ID3D12DescriptorHeap			*m_pHeap;
	UINT							BlockSize;

public:
	CResManager();
	~CResManager();
	bool Init( ID3D12Device *device, ID3D12DescriptorHeap *heap );
	D3D12_CPU_DESCRIPTOR_HANDLE CreateCPUHandle(int64_t* num);
	D3D12_GPU_DESCRIPTOR_HANDLE GetGPUHandle(int64_t num);
	bool FreeResourceNum(int64_t num);
};

#endif