/////////////////////////////////////////////////
//
//  filename: MainWindow.h
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

class CButtonClose;
class CButtonMinimize;
class CButtonOpen;
class CButtonPlay;
class CButtonPause;
class CButtonStop;
class CButtonCloseA;
class CButtonLoop;
class CButtonExit;

class CMainWindow{
public:

	HWND			m_hWnd;
	UINT			TimerID;

	CButtonOpen		*ButtonOpen;
	CButtonPlay		*ButtonPlay;
	CButtonPause	*ButtonPause;
	CButtonStop		*ButtonStop;
	CButtonLoop		*ButtonLoop;
	CButtonCloseA	*ButtonCloseA;
	CButtonExit		*ButtonExit;

	CPCMAudio		*Audio;
	int				CurrentID;
	int				IDSize;
	int				TotalTime;
	int				PlayTime;

	HICON			hIcon;
	int				DisplayWidth, DisplayHeight;
	int				FrameEdgeX, FrameEdgeY;
	int				TaskBarHeight;
	int				Width, Height;
	int				PosX, PosY;
	int				TitleBarHeight;
	int				BKColorA, BKColorR, BKColorG, BKColorB;
	int				BarColorA, BarColorR, BarColorG, BarColorB;
	bool			LButtonDown;
	bool			GetCaption;
	CPoint			DownPoint;
	float			ScaleX, ScaleY;

	double		SeekPos;
	int			SeekPosX;
	int			SeekPosY;
	int			SeekWidth;
	int			SeekHeight;
	bool		SeekCapture;

	double		VolumePos;
	double		BGMVolume;
	int			VolumePosX;
	int			VolumePosY;
	int			VolumeWidth;
	int			VolumeHeight;
	bool		VolumeCapture;

	char			*AlphaBMP;
	HDC				MemDC;
	HBITMAP			MemBMP;
	int				BitmapWidth;
	int				BitmapHeight;

	CButtonClose		*ButtonClose;
	CButtonMinimize	*ButtonMinimize;

	CMainWindow();
	~CMainWindow();
	bool CreateWnd();
	bool OnDraw(HDC hdc);
	bool DrawPlayButton(Gdiplus::Graphics *gfc);
	bool DrawSoundList(Gdiplus::Graphics *gfc);
	bool DrawSpectrum(Gdiplus::Graphics *gfc);
	bool DrawRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Pen *pen, int x, int y, int w, int h, int r);
	bool FillRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Brush *brush, int x, int y, int w, int h, int r);

public:
	void OnPaint();
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnMouseMove(UINT nFlag, CPoint point);
	void OnSize(UINT nType, int cx, int cy);

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT MainWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	static void CALLBACK  TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2);

};

#endif