/////////////////////////////////////////////////
//
//  filename: MainWindow.cpp
//  author:
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "MainWindow.h"
#include "CustomButton.h"

CMainWindow::CMainWindow(){

	HDC screen = GetDC(0);
	float dpiX = static_cast<FLOAT>(GetDeviceCaps(screen, LOGPIXELSX));
	float dpiY = static_cast<FLOAT>(GetDeviceCaps(screen, LOGPIXELSY));
	ReleaseDC(0, screen);

	ScaleX = dpiX / 96.0f;
	ScaleY = dpiY / 96.0f;

	DisplayWidth = ::GetSystemMetrics(SM_CXSCREEN);
	DisplayHeight = ::GetSystemMetrics(SM_CYSCREEN);
	FrameEdgeX = ::GetSystemMetrics(SM_CXFRAME);
	FrameEdgeY = ::GetSystemMetrics(SM_CYFRAME);

	Width = (int) ((double) DisplayWidth / 2.5 );
	Height = (int)((double) DisplayHeight / 2.5 );
	TitleBarHeight = (int) ((double)DisplayHeight / 30.0);

	BKColorA = 180;
	BKColorR = 180;
	BKColorG = 150;
	BKColorB = 150;
	BarColorA = 180;
	BarColorR = 100;
	BarColorG = 70;
	BarColorB = 70;

	PosX = (DisplayWidth - Width) / 2;
	PosY = (DisplayHeight - Height) / 2;

	LButtonDown = false;
	GetCaption = false;
	TimerID = 0;
	DownPoint = CPoint(0, 0);
}

CMainWindow::~CMainWindow(){
}

bool CMainWindow::CreateWnd(){


	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CMainWindow::WindowProc;
	wcx.lpszClassName = L"CLASS_MAINWINDOW";
	RegisterClassEx(&wcx);
	
	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_MAINWINDOW", _T("SoundDebugWindow"), WS_OVERLAPPED | WS_CLIPCHILDREN, PosX, PosY, Width, Height, GetDesktopWindow(), NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);
	::SetWindowLong(m_hWnd, GWL_EXSTYLE, WS_EX_LAYERED);

	HRGN rgn = CreateRectRgn(FrameEdgeX, (int)(FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION)), Width, Height);
	::SetWindowRgn(m_hWnd, rgn, TRUE);
	::DeleteObject(rgn);

	BitmapWidth = DisplayWidth;
	BitmapHeight = DisplayHeight;

	BITMAPINFO  bmi = { 0 };
	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = BitmapWidth;
	bmi.bmiHeader.biHeight = BitmapHeight;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biBitCount = 32;

	MemBMP = CreateDIBSection(0, &bmi, DIB_RGB_COLORS, (void **)&AlphaBMP, 0, 0);
	::DeleteDC(MemDC);

	HDC hdc = ::GetDC(m_hWnd);
	MemDC = CreateCompatibleDC(hdc);
	::SelectObject(MemDC, MemBMP);
	DeleteDC(hdc);

	Audio = new CPCMAudio();
	Audio->Init(m_hWnd, 0);

	SeekPosX = (int)(((double) Width / 500.0) * 50.0);
	SeekPosY = (int)(((double) Height / 500.0) * 370.0) ;
	SeekWidth = (int)((double) Width / 4.0 );
	SeekHeight = (int)((double) Height / 20.0 );

	VolumePosX = SeekPosX + SeekWidth + (int) ((double) Width / 20.0 );
	VolumePosY = SeekPosY;
	VolumeWidth = (int)((double) Width / 6.0 );
	VolumeHeight = (int) ((double) Height / 20.0 );

	int button_size = (int) ((double) Width / 35.0 );
	int x = Width - button_size - (int) ((double) Width / 50.0 );
	int y = (int) ((double) Height / 100.0 );
	ButtonClose = new CButtonClose();
	ButtonClose->CreateWnd(x, y, button_size, button_size, m_hWnd);
	ButtonClose->SetImage(L"./pict/ButtonClose.png", L"./pict/ButtonCloseDown.png");

	x -= button_size + (int) ((double) Width / 100.0 );
	ButtonMinimize = new CButtonMinimize();
	ButtonMinimize->CreateWnd(x, y, button_size, button_size, m_hWnd);
	ButtonMinimize->SetImage(L"./pict/ButtonMin.png", L"./pict/ButtonMinDown.png");

	int button_width = (int) ((double) Width / 7.0) - (int) ((double) Width / 40.0 );
	int button_height = (int) (((double) Height / 500.0 ) * 80.0 );

	x = (int) (((double) Width / 500.0 ) * 25.0 );
	y = (int)(((double)Height / 500.0) * 350.0) - ::GetSystemMetrics( SM_CYCAPTION ) + TitleBarHeight;
	ButtonOpen = new CButtonOpen();
	ButtonOpen->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonOpen->SetImage(L"./pict/Open.png", L"./pict/Open_Down.png");

	x += button_width + ((double) Width / 110.0 );
	ButtonPlay = new CButtonPlay();
	ButtonPlay->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonPlay->SetImage(L"./pict/Play.png", L"./pict/Play_Down.png");

	x += button_width + ((double)Width / 110.0);
	ButtonPause = new CButtonPause();
	ButtonPause->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonPause->SetImage(L"./pict/Pause.png", L"./pict/Pause_Down.png");

	x += button_width + ((double)Width / 110.0);
	ButtonStop = new CButtonStop();
	ButtonStop->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonStop->SetImage(L"./pict/Stop.png", L"./pict/Stop_Down.png");

	x += button_width + ((double)Width / 110.0);
	ButtonLoop = new CButtonLoop();
	ButtonLoop->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonLoop->SetImage(L"./pict/Loop.png", L"./pict/Loop_Down.png");

	x += button_width + ((double)Width / 110.0);
	ButtonCloseA = new CButtonCloseA();
	ButtonCloseA->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonCloseA->SetImage(L"./pict/Close.png", L"./pict/Close_Down.png");

	x += button_width + ((double)Width / 110.0);
	ButtonExit = new CButtonExit();
	ButtonExit->CreateWnd(x, y, button_width, button_height, m_hWnd);
	ButtonExit->SetImage(L"./pict/Exit.png", L"./pict/Exit_Down.png");

	::ShowWindow(m_hWnd, SW_SHOW);

	if (TimerID == 0)
		TimerID = ::timeSetEvent( 16, 1, (LPTIMECALLBACK)TimeUpdateCallback, (DWORD_PTR) this, TIME_PERIODIC);

	return true;
}

void CALLBACK  CMainWindow::TimeUpdateCallback(UINT timer_id, UINT msg, LPTIMECALLBACK user, DWORD_PTR data1, DWORD_PTR data2){

	CMainWindow *main_wnd = (CMainWindow *)user;

	::InvalidateRect(main_wnd->m_hWnd, NULL, false);
	::UpdateWindow(main_wnd->m_hWnd);
}

LRESULT CMainWindow::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CMainWindow *main_wnd = (CMainWindow *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (main_wnd != NULL)
		main_wnd->MainWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CMainWindow::MainWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;
	MOUSEHOOKSTRUCT *ms = NULL;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_SIZE:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnSize((UINT)wParam, width, height);
		break;
	case WM_LBUTTONDOWN:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	case WM_MOUSEMOVE:
		x = GET_X_LPARAM(lParam);
		y = GET_Y_LPARAM(lParam);
		OnMouseMove((UINT)wParam, CPoint(x, y));
		break;
	default:
		break;
	}

	return 0;
}

void CMainWindow::OnSize(UINT nType, int cx, int cy){

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CMainWindow::OnPaint(){

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	OnDraw(hdc);
	::EndPaint(m_hWnd, &ps);
}

bool CMainWindow::OnDraw(HDC hdc){

	HBITMAP OldBmp = (HBITMAP)::SelectObject(MemDC, MemBMP);

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(MemDC);
	gfc->Clear(Gdiplus::Color(0, 0, 0, 0));

	Gdiplus::SolidBrush *brush1 = new Gdiplus::SolidBrush(Gdiplus::Color(BarColorA, BarColorR, BarColorG, BarColorB));
	gfc->FillRectangle(brush1, FrameEdgeX, (int)(FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION)), Width, TitleBarHeight);
	delete brush1;

	Gdiplus::SolidBrush *brush2 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, BKColorR, BKColorG, BKColorB));
	gfc->FillRectangle(brush2, FrameEdgeX, (int)(FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION) + TitleBarHeight), Width, Height - TitleBarHeight);
	delete brush2;

	Gdiplus::Pen *pen1 = new Gdiplus::Pen(Gdiplus::Color( BarColorA, BarColorR, BarColorG, BarColorB), 8 );
	gfc->DrawLine(pen1, FrameEdgeX, FrameEdgeY, Width, 0);
	gfc->DrawLine(pen1, Width, 0, Width, Height);
	gfc->DrawLine(pen1, Width, Height, FrameEdgeX, Height);
	gfc->DrawLine(pen1, FrameEdgeX, Height, FrameEdgeX, 0);
	delete pen1;

	gfc->SetTextRenderingHint(Gdiplus::TextRenderingHintAntiAlias);
	Gdiplus::Font *font = new Gdiplus::Font(L"CI", (REAL)((double) TitleBarHeight * 0.5f / ScaleX ));

	size_t size;
	wchar_t wstr[60];
	Gdiplus::SolidBrush *brush3 = new Gdiplus::SolidBrush(Gdiplus::Color(255, BKColorR + 30, BKColorG + 30, BKColorB + 30));
	char str[SIZE_CHAR_MAX];
	memset(str, 0, SIZE_CHAR_MAX);
	strcpy_s(str, SIZE_CHAR_MAX, "SoundDebugWindow");
	Gdiplus::StringFormat *format = new Gdiplus::StringFormat(StringFormatFlagsNoWrap);
	wmemset(wstr, 0, 60);
	mbstowcs_s(&size, wstr, str, strlen(str));
	gfc->DrawString(wstr, -1, font, RectF((double)Width / 50.0, ::GetSystemMetrics(SM_CYCAPTION) + (double)Height / 100.0, (REAL)Width, (REAL)TitleBarHeight), format, brush3);

	delete brush3;
	delete font;
	delete format;

	DrawSoundList(gfc);
	DrawPlayButton(gfc);
	DrawSpectrum(gfc);

	SIZE size1;
	size1.cx = Width;
	size1.cy = Height;

	BLENDFUNCTION bf;
	bf.BlendOp = AC_SRC_OVER;
	bf.BlendFlags = 0;
	bf.AlphaFormat = AC_SRC_ALPHA;
	bf.SourceConstantAlpha = 255;

	ButtonClose->OnDraw(MemDC, ButtonClose->PosX + FrameEdgeX, ButtonClose->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonClose->Width, ButtonClose->Height);
	ButtonMinimize->OnDraw(MemDC, ButtonMinimize->PosX + FrameEdgeX, ButtonMinimize->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonMinimize->Width, ButtonMinimize->Height);
	ButtonOpen->OnDraw(MemDC, ButtonOpen->PosX + FrameEdgeX, ButtonOpen->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonOpen->Width, ButtonOpen->Height);
	ButtonPlay->OnDraw(MemDC, ButtonPlay->PosX + FrameEdgeX, ButtonPlay->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonPlay->Width, ButtonPlay->Height);
	ButtonPause->OnDraw(MemDC, ButtonPause->PosX + FrameEdgeX, ButtonPause->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonPause->Width, ButtonPause->Height);
	ButtonStop->OnDraw(MemDC, ButtonStop->PosX + FrameEdgeX, ButtonStop->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonStop->Width, ButtonStop->Height);
	ButtonLoop->OnDraw(MemDC, ButtonLoop->PosX + FrameEdgeX, ButtonLoop->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonLoop->Width, ButtonLoop->Height);
	ButtonCloseA->OnDraw(MemDC, ButtonCloseA->PosX + FrameEdgeX, ButtonCloseA->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonCloseA->Width, ButtonCloseA->Height);
	ButtonExit->OnDraw(MemDC, ButtonExit->PosX + FrameEdgeX, ButtonExit->PosY + FrameEdgeY + ::GetSystemMetrics(SM_CYCAPTION), ButtonExit->Width, ButtonExit->Height);

	::UpdateLayeredWindow(m_hWnd, hdc, &CPoint(PosX, PosY), &size1, MemDC, &CPoint(0, 0), 0, &bf, ULW_ALPHA);

	delete gfc;


	return true;
}

bool CMainWindow::DrawSoundList(Gdiplus::Graphics *gfc){

	//TEhXg\

	int r1 = BKColorR + 60;
	int g1 = BKColorG + 60;
	int b1 = BKColorB + 60;

	int r2 = BKColorR + 20;
	int g2 = BKColorG + 20;
	int b2 = BKColorB + 20;

	int r3 = BKColorR - 20;
	int g3 = BKColorG - 20;
	int b3 = BKColorB - 20;

	Gdiplus::SolidBrush *brush1 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r1, g1, b1));
	Gdiplus::SolidBrush *brush2 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r2, g2, b2));
	Gdiplus::SolidBrush *brush3 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r3, g3, b3));

	gfc->SetTextRenderingHint(Gdiplus::TextRenderingHintAntiAlias);

	int font_size = (int)((double)TitleBarHeight * 0.4f / ScaleX);
	Gdiplus::Font *font = new Gdiplus::Font(L"CI", (REAL)font_size);

	wchar_t str[SIZE_CHAR_MAX];

	int text_width = Width;
	int text_height = font_size + (int) ((double) Height / 30.0 );
	Gdiplus::StringFormat *format = new Gdiplus::StringFormat(StringFormatFlagsNoWrap);

	int box_x = (int)(((double)Width / 500.0) * 20.0);
	int box_y = (int)(((double)Height / 500.0) * 100.0) + ::GetSystemMetrics(SM_CYCAPTION) - TitleBarHeight;
	int box_height = (int)(((double)Height / 500.0) * 240.0);
	int box_width = (int)(((double)Width / 500.0) * 200.0);
	int box_arc = (int)((double)Width / 30.0);
	int line_w = (int)((double)Width / 300.0);
	int item_height = font_size + (int)((double)Height / 25.0);

	Gdiplus::Pen *pen = new Gdiplus::Pen(brush1, (REAL)line_w);
	FillRoundRect(gfc, brush2, box_x, box_y, box_width, box_height, box_arc);
	DrawRoundRect(gfc, pen, box_x, box_y, box_width, box_height, box_arc);

	/////////////////////////////////////////////Xg\//////////////////////////////////////////////

	for (int i = 1; i <= 30; i++){
		if (IDSize < i)
			break;
		if ( ( i + 1 ) * item_height > box_height)
			break;

		CListData *list_data = (CListData *)Audio->AudioList->GetAt(i);
		CAudioData *audio_data = (CAudioData *)list_data->Data;
		wchar_t file_name[SIZE_CHAR_MAX];
		wmemset(file_name, 0, SIZE_CHAR_MAX);
		wmemcpy(file_name, audio_data->FileName, wcslen(audio_data->FileName) - 4);
		wmemset(str, 0, SIZE_CHAR_MAX);
		wchar_t data[SIZE_CHAR_MAX];
		wmemset(data, 0, SIZE_CHAR_MAX);
		swprintf_s(data, SIZE_CHAR_MAX, L"%d. ", i);
		wcscpy_s(str, SIZE_CHAR_MAX, data);
		wcscat_s(str, SIZE_CHAR_MAX, file_name);

		if (Audio->GetID( i ) == CurrentID){
			gfc->FillRectangle(brush3, box_x + (double) Width / 200.0, box_y + i * item_height - (double) Height / 100.0, box_width - (double) Width / 100.0, item_height);
			gfc->DrawString(str, -1, font, RectF((REAL)(box_x + (double) Width / 50.0), (REAL)box_y + i * item_height - (double) Height / 100.0, (REAL)(box_width - (double) Width / 50.0), (REAL)item_height), format, brush1);
		}
		else{
			gfc->DrawString(str, -1, font, RectF((REAL)(box_x + (double) Width / 50.0), (REAL)box_y + i * item_height - (double) Height / 100.0, (REAL)(box_width - (double) Width / 50.0), (REAL)item_height), format, brush1);
		}
	}

	delete font;
	delete format;
	delete brush1;
	delete brush2;
	delete brush3;

	return true;
}

bool CMainWindow::DrawSpectrum(Gdiplus::Graphics *gfc){

	//XyNg\

	int r1 = BKColorR + 60;
	int g1 = BKColorG + 60;
	int b1 = BKColorB + 60;

	int r2 = BKColorR + 20;
	int g2 = BKColorG + 20;
	int b2 = BKColorB + 20;

	int r3 = BKColorR + 30;
	int g3 = BKColorG - 30;
	int b3 = BKColorB - 30;

	int r4 = BKColorR - 30;
	int g4 = BKColorG - 30;
	int b4 = BKColorB + 30;

	Gdiplus::SolidBrush *brush1 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r1, g1, b1));
	Gdiplus::SolidBrush *brush2 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r2, g2, b2));
	Gdiplus::SolidBrush *brush3 = new Gdiplus::SolidBrush(Gdiplus::Color(255, r3, g3, b3));
	Gdiplus::SolidBrush *brush4 = new Gdiplus::SolidBrush(Gdiplus::Color(255, r4, g4, b4));

	int box_x = (int)(((double)Width / 500.0) * 230.0);
	int box_y = (int)(((double)Height / 500.0) * 100.0) + ::GetSystemMetrics(SM_CYCAPTION) - TitleBarHeight;
	int box_height = (int)(((double)Height / 500.0) * 240.0);
	int box_width = (int)(((double)Width / 500.0) * 250.0);
	int box_arc = (int) ((double) Width / 30.0 );
	int line_w = (int) ((double) Width / 300.0 );

	Gdiplus::Pen *pen = new Gdiplus::Pen(brush1, (REAL)line_w);
	FillRoundRect(gfc, brush2, box_x, box_y, box_width, box_height, box_arc);
	DrawRoundRect(gfc, pen, box_x, box_y, box_width, box_height, box_arc);

	int w = (int) (((double) box_width / 2.0 ) / 18.0 );
	for (int i = 4; i <= 24; i++){
		if (Audio->GetStatus(Audio->CurrentID) == AUDIO_STATUS_PLAYING){
			int f_left = (int)( Audio->FFTLeft[i] / 3.0f );
			int f_right = (int)( Audio->FFTRight[i] / 3.0f );
			if (f_left > box_height - (double) Height / 100.0)
				f_left = box_height - (double)Height / 100.0;
			if (f_right > box_height - (double)Height / 100.0)
				f_right = box_height - (double)Height / 100.0;
			gfc->FillRectangle(brush3, Gdiplus::RectF((REAL)(box_x + w * (i - 8)), (REAL)(box_y + box_height - f_left - 2), (REAL)(w - 2), (REAL)f_left));
			gfc->FillRectangle(brush4, Gdiplus::RectF((REAL)(box_x + w * (i - 8) + box_width / 2), (REAL)(box_y + box_height - f_right - 2), (REAL)(w - 2), (REAL)f_right));
		}
	}

	delete brush1;
	delete brush2;
	delete brush3;
	delete brush4;
	delete pen;

	return true;
}

bool CMainWindow::DrawPlayButton(Gdiplus::Graphics *gfc){

	//vC[{^\

	int r1 = BKColorR - 80;
	int g1 = BKColorG - 80;
	int b1 = BKColorB - 80;

	int r2 = BKColorR - 50;
	int g2 = BKColorG - 50;
	int b2 = BKColorB - 50;

	int r3 = BKColorR - 20;
	int g3 = BKColorG - 20;
	int b3 = BKColorB - 20;

	int r4 = BKColorR + 10;
	int g4 = BKColorG - 10;
	int b4 = BKColorB - 10;

	int r5 = BKColorR + 40;
	int g5 = BKColorG + 40;
	int b5 = BKColorB + 40;

	Gdiplus::SolidBrush *brush1 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r1, g1, b1));
	Gdiplus::SolidBrush *brush2 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r2, g2, b2));
	Gdiplus::SolidBrush *brush3 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r3, g3, b3));
	Gdiplus::SolidBrush *brush4 = new Gdiplus::SolidBrush(Gdiplus::Color(255, r4, g4, b4));
	Gdiplus::SolidBrush *brush5 = new Gdiplus::SolidBrush(Gdiplus::Color(BKColorA, r5, g5, b5));

	gfc->SetTextRenderingHint(Gdiplus::TextRenderingHintAntiAlias);

	int font_size = (int)((double)TitleBarHeight * 0.4f / ScaleX);
	Gdiplus::Font *font = new Gdiplus::Font(L"CI", (REAL)font_size);

	int text_width = Width;
	int text_height = font_size + (int) ((double) Height / 100.0 );
	Gdiplus::StringFormat *format = new Gdiplus::StringFormat(StringFormatFlagsNoWrap);

	int box_x = (int)(((double) Width / 500.0) * 25.0);
	int box_y = (int)(((double)Height / 500.0) * 360.0) + ::GetSystemMetrics(SM_CYCAPTION) - TitleBarHeight;
	int box_height = (int)(((double)Height / 500.0) * 120.0) - (::GetSystemMetrics(SM_CYCAPTION) - TitleBarHeight);
	int box_width = Width - box_x * 2;
	int box_arc = (int) ((double) Width / 30.0 );
	int line_w = (int) ((double) Width / 300.0 );

	Gdiplus::Pen *pen = new Gdiplus::Pen(brush1, (REAL)line_w);
	FillRoundRect(gfc, brush2, box_x, box_y, box_width, box_height, box_arc);
	DrawRoundRect(gfc, pen, box_x, box_y, box_width, box_height, box_arc);
	
	//ԕ\
	if (SeekCapture == false)
		SeekPos = Audio->GetPlayPos(CurrentID);
	if (VolumeCapture == false){
		if (CurrentID > 0)
			VolumePos = Audio->GetVolume(CurrentID);
	}
	PlayTime = (int)Audio->GetPlayingTime(CurrentID);
	TotalTime = Audio->GetTotalTime(CurrentID);
	int total_hour = TotalTime / 3600;
	int total_min = (TotalTime - total_hour * 3600) / 60;
	int total_sec = TotalTime - total_hour * 3600 - total_min * 60;
	int play_hour = PlayTime / 3600;
	int play_min = (PlayTime - play_hour * 3600) / 60;
	int play_sec = PlayTime - play_hour * 3600 - play_min * 60;

	wchar_t text_time[SIZE_CHAR_MAX];
	wmemset(text_time, 0, SIZE_CHAR_MAX);
	swprintf_s(text_time, SIZE_CHAR_MAX, L"%02d:%02d:%02d / %02d:%02d:%02d", play_hour, play_min, play_sec, total_hour, total_min, total_sec);
	gfc->DrawString(text_time, -1, font, RectF((REAL)(box_x + box_width - (double) Width / 3.1), (REAL)(box_y + (double) Height / 40.0), (REAL)((double) Width / 3), (REAL)((double) Height / 10.0)), format, brush5);

	//V[No[
	Gdiplus::Pen *pen2 = new Gdiplus::Pen(brush5, 2);
	FillRoundRect(gfc, brush3, SeekPosX, SeekPosY, SeekWidth, SeekHeight, 5);
	DrawRoundRect(gfc, pen, SeekPosX, SeekPosY, SeekWidth, SeekHeight, 5);
	int pos = (int)(SeekPos * SeekWidth);
	FillRoundRect(gfc, brush4, SeekPosX + pos - (double)Width / 200.0, SeekPosY, (double)Width / 100.0, SeekHeight, 3);
	DrawRoundRect(gfc, pen2, SeekPosX + pos - (double)Width / 200.0, SeekPosY, (double)Width / 100.0, SeekHeight, 3);

	//{[o[
	FillRoundRect(gfc, brush3, VolumePosX, VolumePosY, VolumeWidth, VolumeHeight, 5);
	DrawRoundRect(gfc, pen, VolumePosX, VolumePosY, VolumeWidth, VolumeHeight, 5);
	int w = 3;
	int h = VolumeHeight / 6;
	for (int i = 0; i <= 5; i++){
		gfc->FillRectangle(brush1, VolumePosX + VolumeWidth + i * (w + 1) + 6, VolumePosY + h * (6 - i), w, h *(i + 1));
	}
	pos = (int)(VolumePos * VolumeWidth);
	FillRoundRect(gfc, brush4, VolumePosX + pos - (double)Width / 200.0, VolumePosY, (double)Width / 100.0, VolumeHeight, 3);
	DrawRoundRect(gfc, pen2, VolumePosX + pos - (double)Width / 200.0, VolumePosY, (double)Width / 100.0, VolumeHeight, 3);
	
	delete font;
	delete format;
	delete brush1;
	delete brush2;
	delete brush3;
	delete brush4;
	delete brush5;
	delete pen;
	delete pen2;

	return true;
}

bool CMainWindow::DrawRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Pen *pen, int x, int y, int w, int h, int r){

	if (r % 2 != 0)
		r++;

	gfc->DrawArc(pen, x, y, r, r, 180, 90);
	gfc->DrawArc(pen, x + w - r, y, r, r, 270, 90);
	gfc->DrawArc(pen, x, y + h - r, r, r, 90, 90);
	gfc->DrawArc(pen, x + w - r, y + h - r, r, r, 0, 90);
	gfc->DrawLine(pen, x + r / 2, y, x + w + 1 - r / 2, y);
	gfc->DrawLine(pen, x, y + r / 2, x, y + h + 1 - r / 2);
	gfc->DrawLine(pen, x + w, y + r / 2, x + w + 1, y + h + 1 - r / 2);
	gfc->DrawLine(pen, x + r / 2, y + h, x + w + 1 - r / 2, y + h + 1);

	return true;
}

bool CMainWindow::FillRoundRect(Gdiplus::Graphics *gfc, Gdiplus::Brush *brush, int x, int y, int w, int h, int r){

	if (r % 2 != 0)
		r++;

	gfc->FillPie(brush, x, y, r, r, 180, 90);
	gfc->FillPie(brush, x + w - r, y, r, r, 270, 90);
	gfc->FillPie(brush, x, y + h - r, r, r, 90, 90);
	gfc->FillPie(brush, x + w - r, y + h - r, r, r, 0, 90);
	gfc->FillRectangle(brush, x + r / 2, y, w - r, r / 2);
	gfc->FillRectangle(brush, x, y + r / 2, r / 2, h - r);
	gfc->FillRectangle(brush, x + r / 2, y + h - r / 2, w - r, r / 2);
	gfc->FillRectangle(brush, x + w - r / 2, y + r / 2, r / 2, h - r);
	gfc->FillRectangle(brush, x + r / 2, y + r / 2, w - r, h - r);

	return true;
}

void CMainWindow::OnLButtonDown(UINT nFlag, CPoint point){

	LButtonDown = true;

	if (point.y < TitleBarHeight)
		GetCaption = true;
	else
		GetCaption = false;

	int pos_x = point.x;
	int pos_y = point.y + FrameEdgeY * 2 + ::GetSystemMetrics(SM_CYCAPTION);
	if (pos_x > SeekPosX - 12 && pos_x < SeekPosX + SeekWidth + 12 && pos_y > SeekPosY && pos_y < SeekPosY + SeekHeight){
		SeekPos = (double)(pos_x - SeekPosX) / (double)SeekWidth;
		SeekCapture = true;
	}
	if (pos_x > VolumePosX - 12 && pos_x < VolumePosX + VolumeWidth + 12 && pos_y > VolumePosY && pos_y < VolumePosY + VolumeHeight){
		VolumePos = (double)(pos_x - VolumePosX) / (double)VolumeWidth;
		VolumeCapture = true;
	}

	/////////////////////////////////////////////////////////
	// t@C̃NbN
	
	pos_x = point.x;
	pos_y = point.y + ::GetSystemMetrics(SM_CYCAPTION);
	int font_size = (int)((double)TitleBarHeight * 0.4f / ScaleX);
	int box_x = (int)(((double)Width / 500.0) * 20.0);
	int box_y = (int)(((double)Height / 500.0) * 100.0);
	int box_height = (int)(((double)Height / 500.0) * 240.0);
	int box_width = (int)(((double)Width / 500.0) * 200.0);
	int box_arc = (int)((double)Width / 30.0);
	int line_w = (int)((double)Width / 300.0);
	int item_height = font_size + (int)((double)Height / 25.0);

	if (pos_x > box_x && pos_x < box_x + box_width && pos_y > box_y && pos_y < box_y + box_height){
		int i = (pos_y - box_y - (double)Height / 100.0) / item_height;
		if (i < IDSize && i >= 0 ){
			int id = Audio->GetID(i + 1);
			CurrentID = id;
			Audio->CurrentID = CurrentID;
		}
	}
	
	/////////////////////////////////////////////////////////

	::ClientToScreen(m_hWnd, &point);
	DownPoint = point;
	LButtonDown = true;
	::SetCapture(m_hWnd);
	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CMainWindow::OnLButtonUp(UINT nFlag, CPoint point){

	if ( SeekCapture == true )
		Audio->Seek(Audio->CurrentID, SeekPos);

	::ReleaseCapture();
	LButtonDown = false;
	SeekCapture = false;
	VolumeCapture = false;
	GetCaption = false;

	::InvalidateRect(m_hWnd, NULL, false);
	::UpdateWindow(m_hWnd);
}

void CMainWindow::OnMouseMove(UINT nFlag, CPoint point){

	if (LButtonDown == true && GetCaption == true ){
		::ClientToScreen( m_hWnd, &point);
		PosX += point.x - DownPoint.x;
		PosY += point.y - DownPoint.y;
		DownPoint = point;
		::SetWindowPos(m_hWnd, HWND_TOP, PosX, PosY, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}

	if (LButtonDown == true && SeekCapture == true){
		int pos_x = point.x;
		SeekPos = (double)(pos_x - SeekPosX) / (double)SeekWidth;
		if (SeekPos < 0)
			SeekPos = 0.0;
		if (SeekPos > 1.0)
			SeekPos = 1.0;
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}
	if (LButtonDown == true && VolumeCapture == true){
		int pos_x = point.x;
		VolumePos = (double)(pos_x - VolumePosX) / (double)VolumeWidth;
		if (VolumePos < 0)
			VolumePos = 0.0;
		if (VolumePos > 1.0)
			VolumePos = 1.0;
		Audio->SetVolume(CurrentID, VolumePos);
		::InvalidateRect(m_hWnd, NULL, false);
		::UpdateWindow(m_hWnd);
	}

}
