/////////////////////////////////////////////////
//
//  filename: CustomButton.jpp
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "Main.h"
#include "CustomButton.h"
#include "MainWindow.h"

CCustomButton::CCustomButton(){

	Width = 0;
	Height = 0;
	PosX = PosY = 0;
	LButtonDown = false;
	ButtonImage = NULL;
	ButtonDownImage = NULL;
	FrameEdgeX = ::GetSystemMetrics(SM_CXFRAME);
	FrameEdgeY = ::GetSystemMetrics(SM_CYFRAME);
}

CCustomButton::~CCustomButton(){

}

bool CCustomButton::Action(){

	return true;
}

void CCustomButton::OnLButtonDown(UINT nFlag, CPoint point){

	::SetCapture( m_hWnd );
	LButtonDown = true;

	
	::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->m_hWnd);
}

void CCustomButton::OnLButtonUp(UINT nFlag, CPoint point){

	::ReleaseCapture();
	LButtonDown = false;

	Action();

	::InvalidateRect(theApp->MainWindow->m_hWnd, NULL, false);
	::UpdateWindow(theApp->MainWindow->m_hWnd);
}

void CCustomButton::OnPaint(){

	PAINTSTRUCT ps;
	HDC hdc = ::BeginPaint(m_hWnd, &ps);
	OnDraw(hdc);
	::EndPaint(m_hWnd, &ps);
}

bool CCustomButton::OnDraw(HDC hdc){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	if (LButtonDown == true)
		gfc->DrawImage( ButtonDownImage, FrameEdgeX, FrameEdgeY, Width, Height);
	else
		gfc->DrawImage(ButtonImage, FrameEdgeX, FrameEdgeY, Width, Height);

	delete gfc;

	return true;
}

bool CCustomButton::OnDraw(HDC hdc, int pos_x, int pos_y, int width, int height ){

	Gdiplus::Graphics *gfc = new Gdiplus::Graphics(hdc);

	if (LButtonDown == true)
		gfc->DrawImage(ButtonDownImage, pos_x + FrameEdgeX, pos_y + FrameEdgeY, width, height);
	else
		gfc->DrawImage(ButtonImage, pos_x + FrameEdgeX, pos_y + FrameEdgeY, width, height );

	delete gfc;

	return true;
}

bool CCustomButton::CreateWnd(int x, int y, int w, int h, HWND ParentWnd){

	WNDCLASSEX wcx;
	memset(&wcx, 0, sizeof(WNDCLASSEX));
	wcx.style = CS_HREDRAW | CS_VREDRAW;
	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.hInstance = NULL;
	wcx.hIcon = NULL;
	wcx.lpszMenuName = NULL;
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.lpfnWndProc = &CCustomButton::WindowProc;
	wcx.lpszClassName = L"CLASS_CUSTOMBUTTON";
	RegisterClassEx(&wcx);

	PosX = x;
	PosY = y;
	Width = w;
	Height = h;

	m_hWnd = CreateWindowEx(WS_EX_LEFT, L"CLASS_CUSTOMBUTTON", L"", WS_CHILD, PosX, PosY, Width, Height, ParentWnd, NULL, NULL, NULL);
	::SetWindowLongPtr(m_hWnd, GWLP_USERDATA, (UINT_PTR) this);

	::ShowWindow(m_hWnd, SW_SHOW);

	return true;
}

LRESULT CCustomButton::WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	CCustomButton *button = (CCustomButton *) ::GetWindowLongPtr(hwnd, GWLP_USERDATA);
	if (button != NULL)
		button->CustomButtonWindowProc(hwnd, message, wParam, lParam);

	return DefWindowProc(hwnd, message, wParam, lParam);
}

LRESULT CCustomButton::CustomButtonWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam){

	int width = 0;
	int height = 0;
	int x = 0;
	int y = 0;

	switch (message){
	case WM_PAINT:
		OnPaint();
		break;
	case WM_LBUTTONDOWN:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonDown((UINT)wParam, CPoint(x, y));
		break;
	case WM_LBUTTONUP:
		x = LOWORD(lParam);
		y = HIWORD(lParam);
		OnLButtonUp((UINT)wParam, CPoint(x, y));
		break;
	default:
		break;
	}

	return 0;
}

bool CCustomButton::SetImage(wchar_t* button_img_path, wchar_t * button_down_img_path){

	ButtonImage = Image::FromFile(button_img_path);
	ButtonDownImage = Image::FromFile(button_down_img_path);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonClose::Action(){
	
	::SendMessage( theApp->MainWindow->m_hWnd, WM_DESTROY, 0, 0);
	PostQuitMessage(1);

	return true;
}


///////////////////////////////////////////////////////////////////////////////

bool CButtonMinimize::Action(){

	CMainWindow *main_wnd = (CMainWindow *) theApp->MainWindow;
	::ShowWindow(main_wnd->m_hWnd, SW_MINIMIZE);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool CButtonOpen::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;

	wchar_t filename[SIZE_CHAR_MAX];
	wmemset(filename, 0, SIZE_CHAR_MAX);
	OPENFILENAMEW ofn;
	memset(&ofn, 0, sizeof(OPENFILENAMEW));
	ofn.lStructSize = sizeof(OPENFILENAMEW);
	ofn.hwndOwner = NULL;
	ofn.lpstrFile = filename;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.nMaxFile = SIZE_CHAR_MAX;
	ofn.lpstrTitle = L"Open file";
	int result = GetOpenFileName(&ofn);
	if (result == 1){
		static int id = 1;
		main_wnd->Audio->Open(ofn.lpstrFile, id);
		main_wnd->Audio->CurrentID = id;
		main_wnd->CurrentID = id;
		main_wnd->IDSize++;
		id++;
	}

	return true;
}

bool CButtonPlay::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	main_wnd->Audio->Play(main_wnd->CurrentID);

	return true;
}

bool CButtonPause::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	main_wnd->Audio->Pause(main_wnd->CurrentID);

	return true;
}

bool CButtonStop::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	main_wnd->Audio->Stop(main_wnd->CurrentID);

	return true;
}

bool CButtonLoop::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	main_wnd->Audio->SetLoop(main_wnd->CurrentID, !main_wnd->Audio->GetLoop( main_wnd->CurrentID ));

	return true;
}

bool CButtonCloseA::Action(){

	CMainWindow *main_wnd = (CMainWindow *)theApp->MainWindow;
	main_wnd->Audio->Close(main_wnd->CurrentID);
	main_wnd->CurrentID = main_wnd->Audio->CurrentID;
	main_wnd->IDSize -= 1;

	return true;
}

bool CButtonExit::Action(){

	::SendMessage(theApp->MainWindow->m_hWnd, WM_DESTROY, 0, 0);
	PostQuitMessage(1);

	return true;
}
