/////////////////////////////////////////////////
//
//  filename: CustomButton.h
//  author: 
//  date: 2018/04/03 ver1.00
//		  2020/02/06 ver1.01
//
/////////////////////////////////////////////////

#ifndef __CUSTOMBUTTON_H__
#define __CUSTOMBUTTON_H__

class CCustomButton{
public:

	HWND	m_hWnd;

	int	PosX, PosY;
	int FrameEdgeX, FrameEdgeY;
	int	Width, Height;
	bool LButtonDown;

	Image *ButtonImage;
	Image *ButtonDownImage;

	CCustomButton();
	~CCustomButton();
	bool CreateWnd(int x, int y, int w, int h, HWND ParentWnd);
	virtual bool Action();
	bool OnDraw(HDC hdc);
	bool OnDraw(HDC hdc, int pos_x, int pos_y, int width, int height );
	bool SetImage(wchar_t *button_img_path, wchar_t *button_down_img_path);

public:
	void OnLButtonDown(UINT nFlag, CPoint point);
	void OnLButtonUp(UINT nFlag, CPoint point);
	void OnPaint();

protected:
	static LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT CustomButtonWindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
};

class CButtonClose : public CCustomButton{
public:

	CButtonClose(){};
	~CButtonClose(){};
	bool Action();
};

class CButtonMinimize : public CCustomButton{
public:

	CButtonMinimize(){};
	~CButtonMinimize(){};
	bool Action();
};

class CButtonOpen : public CCustomButton{
public:

	CButtonOpen(){};
	~CButtonOpen(){};
	bool Action();
};

class CButtonPlay : public CCustomButton{
public:

	CButtonPlay(){};
	~CButtonPlay(){};
	bool Action();
};

class CButtonPause : public CCustomButton{
public:

	CButtonPause(){};
	~CButtonPause(){};
	bool Action();
};

class CButtonStop : public CCustomButton{
public:

	CButtonStop(){};
	~CButtonStop(){};
	bool Action();
};

class CButtonLoop : public CCustomButton{
public:

	CButtonLoop(){};
	~CButtonLoop(){};
	bool Action();
};

class CButtonCloseA : public CCustomButton{
public:

	CButtonCloseA(){};
	~CButtonCloseA(){};
	bool Action();
};

class CButtonExit : public CCustomButton{
public:

	CButtonExit(){};
	~CButtonExit(){};
	bool Action();
};

#endif