///////////////////////////////////////////////////
// filename:WAVEAudio.h
// author: Chafumi Touji
// version: 1.0.1
// date: 2018/09/27
//		 2020/02/04
///////////////////////////////////////////////////

#ifndef __WAVEAUDIO_H__
#define __WAVEAUDIO_h__

class CWAVEAudio{
private:
	int												ID;
	int												StartID;
	HWND											ParentWnd;
	HMMIO											hmmio;
	LPDIRECTSOUNDBUFFER				lpDSoundBufferSecondary;
	LPWAVEFORMATEX						WFE_Secondary;
	HANDLE										Thread;
	char												*SampleBuffer;
	int												Pos;
	int												Status;
	int												PlayingPos;
	int												WaveSize;
	int												WaveOffset;
	int												TotalTime;
	int												LoadSize;
	bool												Loop;
	double											Volume;
	bool												PlayOnce;

public:
	CWAVEAudio();
	~CWAVEAudio();
	bool Open(CPCMAudio *audio, wchar_t *filename, HWND parent_wnd, int id, int start_id );
	bool Play();
	bool Pause();
	bool Stop();
	bool Close();
	bool Mute(bool do_mute);
	bool Seek(double pos);
	int GetStatus();
	int GetTotalTime();
	double GetPlayingTime();
	double GetPlayPos();
	double GetVolume();
	int GetBufferPos();
	bool SetVolume(double volume, bool is_mute );
	bool SetLoop(bool loop);
	bool GetLoop();
	bool SetPlayOnce(bool play_once);
	bool GetPlayOnce();
	bool GetSample(int *sample_left, int *sample_right, int sample_count);
	int GetID(){ return ID; };

private:
	bool CreateSoundBuffer(LPDIRECTSOUND lpDSound, LPDIRECTSOUNDBUFFER *lpBuffer, LPWSTR filename);
	static unsigned __stdcall  ThreadStream(LPVOID pParam);
	bool BeginStream();

};

#endif